package cn.antcore.resources.db;

import cn.antcore.resources.KeyConstants;
import cn.antcore.resources.config.SelfConfig;
import com.alibaba.druid.pool.DruidDataSource;
import org.springframework.jdbc.core.JdbcTemplate;

import javax.sql.DataSource;

/**
 * Created By Hong on 2018/7/30
 **/
public final class JdbcUtils {

    /**
     * 配置属性
     **/
    private static SelfConfig CONFIG = SelfConfig.get();

    /**
     * 获取数据连接池
     *
     * @return DataSource
     */
    private static DataSource getDataSource() {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setDriverClassName(CONFIG.getValue(KeyConstants.DB_DRIVER_CLASS_NAME));
        dataSource.setUrl(CONFIG.getValue(KeyConstants.DB_URL));
        dataSource.setUsername(CONFIG.getValue(KeyConstants.DB_USERNAME));
        dataSource.setPassword(CONFIG.getValue(KeyConstants.DB_PASSWORD));
        return dataSource;
    }

    /**
     * 获取JDBC模板
     *
     * @return JdbcTemplate
     */
    public static JdbcTemplate getJdbcTemplate() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate();
        jdbcTemplate.setDataSource(getDataSource());
        return jdbcTemplate;
    }

}
