package cn.antcore.resources.db.select;

import cn.antcore.resources.utils.ArrayUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * 查询SQL构造器
 * Created By Hong on 2018/7/31
 **/
public final class Select {

    private static Map<String, String> SQL_MAP = new HashMap<>();
    private StringBuilder builder = new StringBuilder();
    private boolean isCache = false;

    public Select table(String name) {
        builder.append("select  from ")
                .append(name);
        return this;
    }

    public Select column(String... column) {
        String var1 = ArrayUtils.toString(column);
        builder.insert(7, var1);
        return this;
    }

    public Select columnAll() {
        String var1 = "*";
        builder.insert(7, var1);
        return this;
    }

    @Override
    public String toString() {
        return builder.toString();
    }
}
