/*
 * Decompiled with CFR 0.152.
 */
package cn.antcore.security;

import cn.antcore.security.SecuritySessionFilter;
import cn.antcore.security.filter.AuthorizeFilter;
import cn.antcore.security.filter.AuthorizeFilterImpl;
import cn.antcore.security.filter.LoginStatusFilter;
import cn.antcore.security.filter.RedisLoginStatusFilter;
import cn.antcore.security.handle.ApiAuthorizeInterceptor;
import cn.antcore.security.handle.LoginInterceptor;
import cn.antcore.security.helper.SessionStringRedisSerializer;
import cn.antcore.security.session.SessionIdStrategy;
import cn.antcore.security.session.SessionManager;
import cn.antcore.security.session.SessionStrategy;
import cn.antcore.security.session.max.MaxSession;
import cn.antcore.security.session.max.MaxSessionManager;
import cn.antcore.security.session.refresh.RedisSessionTimeoutRefresh;
import cn.antcore.security.session.refresh.SessionTimeoutRefresh;
import cn.antcore.security.session.strategy.HeaderSessionIdStrategy;
import cn.antcore.security.session.strategy.RedisSessionStrategy;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

public class SecurityCoreConfiguration
implements WebMvcConfigurer {
    @Autowired
    private LoginInterceptor loginInterceptor;
    @Autowired
    private ApiAuthorizeInterceptor apiAuthorizeInterceptor;

    @Bean
    @ConditionalOnMissingBean(value={SessionIdStrategy.class})
    public SessionIdStrategy sessionIdStrategy() {
        return new HeaderSessionIdStrategy();
    }

    @Bean
    @ConditionalOnMissingBean(value={SessionStrategy.class})
    public SessionStrategy sessionStrategy(SessionManager sessionManager) {
        return new RedisSessionStrategy(sessionManager);
    }

    @Bean
    public SecuritySessionFilter securitySessionFilter(@Autowired(required=false) SessionStrategy sessionStrategy) {
        return new SecuritySessionFilter(sessionStrategy);
    }

    @Bean
    @ConditionalOnMissingBean(value={Executor.class})
    public Executor executor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(8);
        executor.setMaxPoolSize(16);
        executor.setQueueCapacity(100);
        executor.setThreadNamePrefix("session-exec-");
        executor.initialize();
        return executor;
    }

    @Bean(name={"applicationEventMulticaster"})
    @ConditionalOnMissingBean(value={SimpleApplicationEventMulticaster.class})
    public SimpleApplicationEventMulticaster applicationEventMulticaster(Executor executor, BeanFactory beanFactory) {
        SimpleApplicationEventMulticaster simpleApplicationEventMulticaster = new SimpleApplicationEventMulticaster(beanFactory);
        simpleApplicationEventMulticaster.setTaskExecutor(executor);
        return simpleApplicationEventMulticaster;
    }

    @Bean(name={"sessionRedisTemplate"})
    @ConditionalOnMissingClass(value={"sessionRedisTemplate"})
    public RedisTemplate<String, Object> sessionRedisTemplate(RedisConnectionFactory connectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(connectionFactory);
        redisTemplate.setKeySerializer((RedisSerializer)new SessionStringRedisSerializer());
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    @Bean
    @ConditionalOnMissingBean(value={RedisSessionTimeoutRefresh.class})
    public SessionTimeoutRefresh sessionTimeoutRefresh() {
        return new RedisSessionTimeoutRefresh();
    }

    @Bean
    @ConditionalOnMissingBean(value={MaxSession.class})
    public MaxSession maxSession() {
        return new MaxSessionManager();
    }

    @Bean
    @ConditionalOnMissingBean(value={LoginStatusFilter.class})
    public LoginStatusFilter loginStatusFilter() {
        return new RedisLoginStatusFilter();
    }

    @Bean
    @ConditionalOnMissingBean(value={AuthorizeFilter.class})
    public AuthorizeFilter authorizeFilter() {
        return new AuthorizeFilterImpl();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.loginInterceptor);
        registry.addInterceptor((HandlerInterceptor)this.apiAuthorizeInterceptor);
    }
}

