/*
 * Decompiled with CFR 0.152.
 */
package cn.antcore.security.el;

import cn.antcore.security.annotation.ApiAuthorize;
import cn.antcore.security.el.ExpressionEvaluator;
import cn.antcore.security.exception.AuthorizeNotConditionException;
import cn.antcore.security.web.DeleteRest;
import cn.antcore.security.web.GetRest;
import cn.antcore.security.web.HeadRest;
import cn.antcore.security.web.OptionsRest;
import cn.antcore.security.web.PatchRest;
import cn.antcore.security.web.PostRest;
import cn.antcore.security.web.PutRest;
import cn.antcore.security.web.TraceRest;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.expression.EvaluationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Aspect
@Component
public class ApiAuthorizeAspect {
    private ExpressionEvaluator<Boolean> evaluator = new ExpressionEvaluator();

    @Around(value="@annotation(cn.antcore.security.annotation.ApiAuthorize) || @annotation(cn.antcore.security.web.GetRest)|| @annotation(cn.antcore.security.web.PostRest) || @annotation(cn.antcore.security.web.DeleteRest) || @annotation(cn.antcore.security.web.PutRest) || @annotation(cn.antcore.security.web.OptionsRest)|| @annotation(cn.antcore.security.web.PatchRest) || @annotation(cn.antcore.security.web.TraceRest)|| @annotation(cn.antcore.security.web.HeadRest)")
    public Object condition(ProceedingJoinPoint joinPoint) throws Throwable {
        Boolean conditionResult = this.getCondition((JoinPoint)joinPoint);
        if (conditionResult.booleanValue()) {
            return joinPoint.proceed();
        }
        throw new AuthorizeNotConditionException("\u6761\u4ef6\u672a\u5339\u914d");
    }

    private String getApiAuthorize(JoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        ApiAuthorize authorize = method.getAnnotation(ApiAuthorize.class);
        if (authorize == null) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = method.getDeclaredAnnotations()) {
                if (annotation instanceof GetRest) {
                    return ((GetRest)annotation).condition();
                }
                if (annotation instanceof PostRest) {
                    return ((PostRest)annotation).condition();
                }
                if (annotation instanceof PutRest) {
                    return ((PutRest)annotation).condition();
                }
                if (annotation instanceof DeleteRest) {
                    return ((DeleteRest)annotation).condition();
                }
                if (annotation instanceof OptionsRest) {
                    return ((OptionsRest)annotation).condition();
                }
                if (annotation instanceof PatchRest) {
                    return ((PatchRest)annotation).condition();
                }
                if (annotation instanceof TraceRest) {
                    return ((TraceRest)annotation).condition();
                }
                if (!(annotation instanceof HeadRest)) continue;
                return ((HeadRest)annotation).condition();
            }
        }
        return authorize.condition();
    }

    private Boolean getCondition(JoinPoint joinPoint) {
        String condition = this.getApiAuthorize(joinPoint);
        if (StringUtils.isEmpty((Object)condition)) {
            return true;
        }
        Object[] args = joinPoint.getArgs();
        if (args == null) {
            args = new Object[]{};
        }
        EvaluationContext evaluationContext = this.evaluator.createEvaluationContext(joinPoint.getTarget(), joinPoint.getTarget().getClass(), ((MethodSignature)joinPoint.getSignature()).getMethod(), args);
        AnnotatedElementKey methodKey = new AnnotatedElementKey((AnnotatedElement)((MethodSignature)joinPoint.getSignature()).getMethod(), joinPoint.getTarget().getClass());
        return this.evaluator.condition(condition, methodKey, evaluationContext, Boolean.class);
    }
}

