/*
 * Decompiled with CFR 0.152.
 */
package cn.antcore.security.helper;

import java.util.Collection;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.stereotype.Component;

@Component
public class ContextUtils
implements ApplicationContextAware,
ApplicationEventPublisherAware {
    private static ApplicationContext applicationContext;
    private static ApplicationEventPublisher applicationEventPublisher;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ContextUtils.applicationContext = applicationContext;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        ContextUtils.applicationEventPublisher = applicationEventPublisher;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static <T> T getBean(Class<T> tClass) {
        return (T)applicationContext.getBean(tClass);
    }

    public static <T> Collection<T> getBeans(Class<T> tClass) {
        return applicationContext.getBeansOfType(tClass).values();
    }

    public static void publishEvent(ApplicationEvent event) {
        applicationEventPublisher.publishEvent(event);
    }
}

