/*
 * Decompiled with CFR 0.152.
 */
package cn.antcore.security.session;

import cn.antcore.security.config.SecurityConfig;
import cn.antcore.security.event.CreateSessionEvent;
import cn.antcore.security.event.UpdateSessionEvent;
import cn.antcore.security.session.SessionIdStrategy;
import cn.antcore.security.session.max.MaxSession;
import cn.antcore.security.session.refresh.SessionTimeoutRefresh;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.event.EventListener;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class SessionManager
implements InitializingBean {
    private static Logger LOG = LoggerFactory.getLogger(SessionManager.class);
    @Autowired
    @Qualifier(value="sessionRedisTemplate")
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private SecurityConfig securityConfig;
    @Autowired
    private SessionIdStrategy sessionIdStrategy;
    @Autowired
    private SessionTimeoutRefresh sessionTimeoutRefresh;
    @Autowired
    private MaxSession maxSession;

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    public SessionIdStrategy getSessionIdStrategy() {
        return this.sessionIdStrategy;
    }

    @EventListener(value={UpdateSessionEvent.class})
    public void updateSessionEvent(UpdateSessionEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u66f4\u65b0Session: {}", (Object)event.getSessionId());
        }
        if (this.securityConfig.isAutomaticRenewal()) {
            this.sessionTimeoutRefresh.refresh(event.getSessionId());
        }
    }

    @EventListener(value={CreateSessionEvent.class})
    public void createSessionEvent(CreateSessionEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u521b\u5efaSession\uff0c\u539f\u59cbSession: {}\uff0c\u65b0Session: {}", (Object)event.getOldSessionId(), (Object)event.getSessionId());
        }
        this.maxSession.handle(event.getSessionId());
    }

    public void afterPropertiesSet() throws Exception {
        this.sessionTimeoutRefresh.setSecurityConfig(this.securityConfig);
        this.sessionTimeoutRefresh.setSessionIdStrategy(this.sessionIdStrategy);
        this.maxSession.setSecurityConfig(this.securityConfig);
        this.maxSession.setSessionIdStrategy(this.sessionIdStrategy);
    }
}

