/*
 * Decompiled with CFR 0.152.
 */
package cn.antcore.security.session.impl;

import cn.antcore.security.config.SecurityConfig;
import cn.antcore.security.entity.UserDetails;
import cn.antcore.security.event.CreateSessionEvent;
import cn.antcore.security.helper.ContextUtils;
import cn.antcore.security.session.LoginSession;
import cn.antcore.security.session.SessionIdStrategy;
import cn.antcore.security.session.impl.UserSessionImpl;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class LoginSessionImpl
extends UserSessionImpl
implements LoginSession {
    private static final Logger LOG = LoggerFactory.getLogger(LoginSessionImpl.class);

    public LoginSessionImpl(HttpServletRequest request, HttpServletResponse response, SecurityConfig securityConfig, SessionIdStrategy sessionIdStrategy, RedisTemplate<String, Object> redisTemplate) {
        super(request, response, securityConfig, sessionIdStrategy, redisTemplate);
    }

    @Override
    public String loginSuccess(UserDetails userDetails) {
        String sessionId = this.getSessionIdStrategy().createSessionId(this.getRequest());
        String oldSession = this.id;
        this.id = sessionId;
        long createTime = System.currentTimeMillis();
        this.getRedisTemplate().opsForValue().set((Object)("UserId:" + userDetails.getId() + ":" + sessionId), (Object)sessionId, this.getSecurityConfig().getSessionTime().getSeconds(), TimeUnit.SECONDS);
        this.setAttribute("CreationTime", createTime);
        this.setAttribute("LastAccessedTime", createTime);
        this.setAttribute("UserDetails", userDetails);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session\u767b\u5f55\u6210\u529f\uff1a{}", (Object)sessionId);
        }
        ContextUtils.publishEvent(new CreateSessionEvent(this, oldSession, sessionId));
        return this.getId();
    }

    @Override
    public void logout() {
        this.invalidate();
    }
}

