/*
 * Decompiled with CFR 0.152.
 */
package cn.antcore.security.session.impl;

import cn.antcore.security.config.SecurityConfig;
import cn.antcore.security.entity.UserDetails;
import cn.antcore.security.session.SessionIdStrategy;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.StringUtils;

public class RedisSecuritySessionImpl
implements HttpSession {
    private static final Logger LOG = LoggerFactory.getLogger(RedisSecuritySessionImpl.class);
    protected String id;
    private RedisTemplate<String, Object> redisTemplate;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private SecurityConfig securityConfig;
    private SessionIdStrategy sessionIdStrategy;

    public RedisSecuritySessionImpl(HttpServletRequest request, HttpServletResponse response, SecurityConfig securityConfig, SessionIdStrategy sessionIdStrategy, RedisTemplate<String, Object> redisTemplate) {
        this.request = request;
        this.response = response;
        this.securityConfig = securityConfig;
        this.redisTemplate = redisTemplate;
        this.sessionIdStrategy = sessionIdStrategy;
        this.id = sessionIdStrategy.getSessionId(request);
    }

    public String buildKey(String ... keys) {
        StringBuffer buffer = new StringBuffer(StringUtils.isEmpty((Object)this.id) ? "temp" : this.id);
        for (String key : keys) {
            buffer.append(":").append(key);
        }
        return buffer.toString();
    }

    public long getCreationTime() {
        return (Long)this.getAttribute("CreationTime");
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        return (Long)this.getAttribute("LastAccessedTime");
    }

    public ServletContext getServletContext() {
        return this.request.getSession().getServletContext();
    }

    public void setMaxInactiveInterval(int i) {
        this.setAttribute("MaxInactiveInterval", i);
    }

    public int getMaxInactiveInterval() {
        return (Integer)this.getAttribute("MaxInactiveInterval");
    }

    public HttpSessionContext getSessionContext() {
        return this.request.getSession().getSessionContext();
    }

    public Object getAttribute(String s) {
        return this.redisTemplate.opsForValue().get((Object)this.buildKey("Attribute", s));
    }

    public Object getValue(String s) {
        return this.getAttribute(s);
    }

    public Enumeration<String> getAttributeNames() {
        Set strings = this.redisTemplate.keys((Object)this.buildKey("Attribute", "*"));
        final int keyLength = this.buildKey("Attribute").length();
        final Iterator iterator = strings.iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public String nextElement() {
                return ((String)iterator.next()).substring(keyLength + 1);
            }
        };
    }

    public String[] getValueNames() {
        Set strings = this.redisTemplate.keys((Object)this.buildKey("Attribute", "*"));
        int keyLength = this.buildKey("Attribute").length();
        String[] values = new String[strings.size()];
        Iterator iterator = strings.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            String value = (String)iterator.next();
            values[index] = value.substring(keyLength + 1);
            ++index;
        }
        return values;
    }

    public void setAttribute(String s, Object o) {
        this.redisTemplate.opsForValue().set((Object)this.buildKey("Attribute", s), o, this.securityConfig.getSessionTime().getSeconds(), TimeUnit.SECONDS);
    }

    public void putValue(String s, Object o) {
        this.setAttribute(s, o);
    }

    public void removeAttribute(String s) {
        this.redisTemplate.delete((Object)this.buildKey("Attribute", s));
    }

    public void removeValue(String s) {
        this.removeAttribute(s);
    }

    public void invalidate() {
        UserDetails userDetails;
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u9500\u6bc1Session: {}", (Object)this.id);
        }
        if ((userDetails = (UserDetails)this.getAttribute("UserDetails")) != null) {
            this.redisTemplate.delete((Object)("UserId:" + userDetails.getId() + ":" + this.id));
        }
        List keys = Arrays.stream(this.getValueNames()).collect(Collectors.toList());
        for (int i = 0; i < keys.size(); ++i) {
            keys.set(i, this.buildKey("Attribute", (String)keys.get(i)));
        }
        this.redisTemplate.delete(keys);
    }

    public boolean isNew() {
        return false;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public SessionIdStrategy getSessionIdStrategy() {
        return this.sessionIdStrategy;
    }

    public SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }
}

