/*
 * Decompiled with CFR 0.152.
 */
package cn.antcore.security.session.max;

import cn.antcore.security.config.SecurityConfig;
import cn.antcore.security.session.SessionIdStrategy;
import cn.antcore.security.session.impl.SessionIdWrapper;
import cn.antcore.security.session.max.MaxSession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.RedisTemplate;

public class MaxSessionManager
implements MaxSession {
    private static final Logger LOG = LoggerFactory.getLogger(MaxSessionManager.class);
    private SecurityConfig securityConfig;
    private SessionIdStrategy sessionIdStrategy;
    @Autowired
    @Qualifier(value="sessionRedisTemplate")
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public void setSecurityConfig(SecurityConfig securityConfig) {
        this.securityConfig = securityConfig;
    }

    @Override
    public void setSessionIdStrategy(SessionIdStrategy sessionIdStrategy) {
        this.sessionIdStrategy = sessionIdStrategy;
    }

    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public void handle(String sessionId) {
        if (this.securityConfig.getMaxLive() <= 0) {
            return;
        }
        SessionIdWrapper wrapper = new SessionIdWrapper(sessionId, this.securityConfig, this.sessionIdStrategy, this.redisTemplate);
        if (!wrapper.isLogin()) {
            return;
        }
        Serializable userId = wrapper.getUserId();
        Set keys = this.redisTemplate.keys((Object)("UserId:" + userId + ":*"));
        Iterator iterator = keys.iterator();
        ArrayList<KeyInfo> keyInfos = new ArrayList<KeyInfo>();
        while (iterator.hasNext()) {
            String oldSessionId = (String)iterator.next();
            Long expire = this.redisTemplate.getExpire((Object)oldSessionId);
            if (sessionId.equals(oldSessionId = oldSessionId.substring(("UserId:" + userId + ":").length()))) continue;
            keyInfos.add(new KeyInfo(oldSessionId, expire));
        }
        if (keys.size() <= this.securityConfig.getMaxLive()) {
            return;
        }
        keyInfos.stream().sorted(Comparator.comparing(KeyInfo::getExpire)).collect(Collectors.toList()).subList(this.securityConfig.getMaxLive() - 1, keys.size() - 1).forEach(it -> new SessionIdWrapper(it.getKey(), this.securityConfig, this.sessionIdStrategy, this.redisTemplate).logout());
    }

    private static class KeyInfo {
        private String key;
        private Long expire;

        public KeyInfo(String key, Long expire) {
            this.key = key;
            this.expire = expire;
        }

        public String getKey() {
            return this.key;
        }

        public Long getExpire() {
            return this.expire;
        }
    }
}

