/*
 * Decompiled with CFR 0.152.
 */
package cn.antcore.security.session.refresh;

import cn.antcore.security.config.SecurityConfig;
import cn.antcore.security.entity.UserDetails;
import cn.antcore.security.session.SessionIdStrategy;
import cn.antcore.security.session.impl.SessionIdWrapper;
import cn.antcore.security.session.refresh.SessionTimeoutRefresh;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisSessionTimeoutRefresh
implements SessionTimeoutRefresh {
    private static final Logger LOG = LoggerFactory.getLogger(RedisSessionTimeoutRefresh.class);
    private SecurityConfig securityConfig;
    private SessionIdStrategy sessionIdStrategy;
    @Autowired
    @Qualifier(value="sessionRedisTemplate")
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public void setSecurityConfig(SecurityConfig securityConfig) {
        this.securityConfig = securityConfig;
    }

    @Override
    public void setSessionIdStrategy(SessionIdStrategy sessionIdStrategy) {
        this.sessionIdStrategy = sessionIdStrategy;
    }

    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public void refresh(String sessionId) {
        SessionIdWrapper wrapper;
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u5237\u65b0Session({})\u7684\u8fc7\u671f\u65f6\u95f4");
        }
        if ((wrapper = new SessionIdWrapper(sessionId, this.securityConfig, this.sessionIdStrategy, this.redisTemplate)).isLogin()) {
            UserDetails userDetails = (UserDetails)wrapper.getAttribute("UserDetails");
            if (userDetails != null) {
                Serializable userId = userDetails.getId();
                this.redisTemplate.expire((Object)("UserId:" + userId + ":" + sessionId), this.securityConfig.getSessionTime().getSeconds(), TimeUnit.SECONDS);
            }
            Enumeration<String> enumeration = wrapper.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String key = wrapper.buildKey("Attribute", enumeration.nextElement());
                this.redisTemplate.expire((Object)key, this.securityConfig.getSessionTime().getSeconds(), TimeUnit.SECONDS);
            }
        }
    }
}

