/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.cache;

import cn.aotcloud.cache.CacheStorage;
import cn.aotcloud.utils.RedisUtil;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisCacheStorage<T>
implements CacheStorage<T> {
    private RedisTemplate<String, T> redisSessionTemplate;
    private String prefix;
    private final Long expiryTime;

    public RedisCacheStorage(RedisConnectionFactory connectionFactory, String prefix, long expiryTime) {
        this.redisSessionTemplate = RedisUtil.redisSessionTemplate(connectionFactory);
        this.prefix = prefix + ":";
        this.expiryTime = expiryTime;
    }

    @Override
    public void addCache(String key, T value) {
        if (this.expiryTime < 0L) {
            this.redisSessionTemplate.opsForValue().set((Object)(this.prefix + key), value, 87600L, TimeUnit.HOURS);
        } else {
            this.redisSessionTemplate.opsForValue().set((Object)(this.prefix + key), value, this.expiryTime.longValue(), TimeUnit.SECONDS);
        }
    }

    @Override
    public T getCache(String key) {
        return (T)this.redisSessionTemplate.opsForValue().get((Object)(this.prefix + key));
    }

    @Override
    public void deleteCache(String key) {
        this.redisSessionTemplate.delete((Object)(this.prefix + key));
    }

    @Override
    public Set<String> keys() {
        return this.redisSessionTemplate.keys((Object)(this.prefix + "*"));
    }
}

