/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.exception;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionUtil {
    public static String getMessage(Throwable t) {
        if (t != null) {
            return t.getMessage();
        }
        return null;
    }

    public static void printStackTrace(Throwable t) {
        if (t != null) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getExceptionInfo(Exception ex) {
        StringWriter stringWriter = null;
        PrintWriter printWriter = null;
        try {
            stringWriter = new StringWriter();
            printWriter = new PrintWriter(stringWriter);
            ex.printStackTrace(printWriter);
            String string = stringWriter.toString();
            if (StringUtils.isNotBlank((CharSequence)string) && string.length() > 30000) {
                string = string.substring(0, 30000);
            }
            String string2 = string;
            return string2;
        }
        finally {
            if (null != stringWriter) {
                try {
                    stringWriter.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (null != printWriter) {
                printWriter.close();
            }
        }
    }

    public static void printLog(Exception exception, boolean showMethodName) {
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        if (stackTraceElementArray != null && stackTraceElementArray.length > 0) {
            String string = stackTraceElementArray[0].getClassName();
            Logger logger = LoggerFactory.getLogger((String)string);
            if (showMethodName) {
                String string2 = stackTraceElementArray[0].getMethodName();
                String string3 = stackTraceElementArray[0].getFileName();
                int n = stackTraceElementArray[0].getLineNumber();
                logger.error("{}({}:{}):{}", new Object[]{string2, string3, n, ExceptionUtil.getMessage(exception)});
            } else {
                logger.error("{}", (Object)ExceptionUtil.getMessage(exception));
            }
        }
    }
}

