/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.oauth2.altu.oauth2.client;

import cn.aotcloud.oauth2.altu.oauth2.client.HttpClient;
import cn.aotcloud.oauth2.altu.oauth2.client.request.OAuthClientRequest;
import cn.aotcloud.oauth2.altu.oauth2.client.response.OAuthAccessTokenResponse;
import cn.aotcloud.oauth2.altu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import cn.aotcloud.oauth2.altu.oauth2.client.response.i111IiI1;
import cn.aotcloud.oauth2.altu.oauth2.common.exception.OAuthProblemException;
import cn.aotcloud.oauth2.altu.oauth2.common.exception.OAuthSystemException;
import java.util.HashMap;

public class OAuthClient {
    protected HttpClient httpClient;

    public OAuthClient(HttpClient oauthClient) {
        this.httpClient = oauthClient;
    }

    public <T extends OAuthAccessTokenResponse> T accessToken(OAuthClientRequest request, Class<T> responseClass) throws OAuthSystemException, OAuthProblemException {
        return this.accessToken(request, "POST", responseClass);
    }

    public <T extends OAuthAccessTokenResponse> T accessToken(OAuthClientRequest request, String requestMethod, Class<T> responseClass) throws OAuthSystemException, OAuthProblemException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Content-Type", "application/json;charset=UTF-8");
        return (T)((OAuthAccessTokenResponse)this.httpClient.execute(request, hashMap, requestMethod, responseClass));
    }

    public OAuthJSONAccessTokenResponse accessToken(OAuthClientRequest request) throws OAuthSystemException, OAuthProblemException {
        return this.accessToken(request, OAuthJSONAccessTokenResponse.class);
    }

    public OAuthJSONAccessTokenResponse accessToken(OAuthClientRequest request, String requestMethod) throws OAuthSystemException, OAuthProblemException {
        return this.accessToken(request, requestMethod, OAuthJSONAccessTokenResponse.class);
    }

    public <T extends i111IiI1> T resource(OAuthClientRequest request, String requestMethod, Class<T> responseClass) throws OAuthSystemException, OAuthProblemException {
        return this.httpClient.execute(request, null, requestMethod, responseClass);
    }

    public void shutdown() {
        this.httpClient.shutdown();
    }
}

