/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.oauth2.altu.oauth2.client;

import cn.aotcloud.oauth2.altu.oauth2.client.HttpClient;
import cn.aotcloud.oauth2.altu.oauth2.client.request.OAuthClientRequest;
import cn.aotcloud.oauth2.altu.oauth2.client.response.i111IiI1;
import cn.aotcloud.oauth2.altu.oauth2.client.response.i1iI111I;
import cn.aotcloud.oauth2.altu.oauth2.common.exception.OAuthProblemException;
import cn.aotcloud.oauth2.altu.oauth2.common.exception.OAuthSystemException;
import cn.aotcloud.utils.HttpTrustUtil;
import cn.aotcloud.utils.URLConnectionClientUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLConnectionClient
extends URLConnectionClientUtil
implements HttpClient {
    protected static Logger logger = LoggerFactory.getLogger(URLConnectionClient.class);

    private static void trustAllHttpsCertificates() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustManagerArray = new TrustManager[]{HttpTrustUtil.createX509TrustManager()};
        SSLContext sSLContext = SSLContext.getInstance("SSL");
        sSLContext.init(null, trustManagerArray, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
    }

    @Override
    public <T extends i111IiI1> T execute(OAuthClientRequest request, Map<String, String> headers, String requestMethod, Class<T> responseClass) throws OAuthSystemException, OAuthProblemException {
        T t;
        InputStream inputStream = null;
        try {
            Map<String, Object> map = this.executeBase(request.getLocationUri(), request.getHeaders(), request.getBody(), headers, requestMethod);
            byte[] byArray = (byte[])map.get("responseBodyBytes");
            inputStream = new ByteArrayInputStream(byArray);
            String string = (String)map.get("contentType");
            int n = (Integer)map.get("responseCode");
            Map map2 = (Map)map.get("responseHeaders");
            t = i1iI111I.II11iIiI(inputStream, string, n, (Map<String, List<String>>)map2, responseClass);
        }
        catch (RuntimeException runtimeException) {
            throw new OAuthSystemException(runtimeException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return t;
    }

    @Override
    public void shutdown() {
    }

    static {
        try {
            URLConnectionClient.trustAllHttpsCertificates();
            HttpsURLConnection.setDefaultHostnameVerifier((urlHostName, session) -> true);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), (Throwable)exception);
        }
    }
}

