/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.oauth2.altu.oauth2.client.response;

import cn.aotcloud.oauth2.altu.oauth2.client.response.OAuthAccessTokenResponse;
import cn.aotcloud.oauth2.altu.oauth2.common.exception.OAuthProblemException;
import cn.aotcloud.oauth2.altu.oauth2.common.token.I111ii1I;
import cn.aotcloud.oauth2.altu.oauth2.common.token.OAuthToken;
import cn.aotcloud.oauth2.altu.oauth2.common.utils.JSONUtils;

public class OAuthJSONAccessTokenResponse
extends OAuthAccessTokenResponse {
    @Override
    public String getAccessToken() {
        return this.getParam("access_token");
    }

    @Override
    public String getTokenType() {
        return this.getParam("token_type");
    }

    @Override
    public Long getExpiresIn() {
        String string = this.getParam("expires_in");
        return string == null ? null : Long.valueOf(string);
    }

    @Override
    public String getScope() {
        return this.getParam("scope");
    }

    @Override
    public OAuthToken getOAuthToken() {
        return new I111ii1I(this.getAccessToken(), this.getTokenType(), this.getExpiresIn(), this.getRefreshToken(), this.getScope());
    }

    @Override
    public String getRefreshToken() {
        return this.getParam("refresh_token");
    }

    @Override
    protected void setBody(String body) throws OAuthProblemException {
        try {
            this.body = body;
            this.parameters = JSONUtils.parseJSON(body);
        }
        catch (Throwable throwable) {
            throw OAuthProblemException.error("unsupported_response_type", "Invalid response! Response body is not application/json;charset=UTF-8 encoded");
        }
    }

    @Override
    protected void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    protected void setResponseCode(int code) {
        this.responseCode = code;
    }
}

