/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.oauth2.altu.oauth2.common.utils;

import cn.aotcloud.oauth2.altu.oauth2.common.exception.OAuthProblemException;
import cn.aotcloud.oauth2.altu.oauth2.common.exception.OAuthSystemException;
import cn.aotcloud.utils.OAuthSafeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;

public final class OAuthUtils {
    public static final String ENCODING = "UTF-8";
    private static final String PARAMETER_SEPARATOR = "&";
    private static final String NAME_VALUE_SEPARATOR = "=";
    public static final String AUTH_SCHEME = "Bearer";
    private static final Pattern OAUTH_HEADER = Pattern.compile("\\s*(\\w*)\\s+(.*)");
    private static final Pattern NVP = Pattern.compile("(\\S*)\\s*\\=\\s*\"([^\"]*)\"");
    public static final String MULTIPART = "multipart/";

    public static String format(Collection<? extends Map.Entry<String, Object>> parameters, String encoding) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Object> entry : parameters) {
            String string;
            String string2;
            String string3 = string2 = entry.getValue() == null ? null : String.valueOf(entry.getValue());
            if (OAuthUtils.isEmpty(entry.getKey()) || OAuthUtils.isEmpty(string2)) continue;
            String string4 = OAuthUtils.encode(entry.getKey(), encoding);
            String string5 = string = string2 != null ? OAuthUtils.encode(string2, encoding) : "";
            if (stringBuilder.length() > 0) {
                stringBuilder.append(PARAMETER_SEPARATOR);
            }
            stringBuilder.append(string4);
            stringBuilder.append(NAME_VALUE_SEPARATOR);
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static String encode(String content, String encoding) {
        try {
            return URLEncoder.encode(content, encoding != null ? encoding : ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(unsupportedEncodingException);
        }
    }

    public static String saveStreamAsString(InputStream is) throws IOException {
        return OAuthUtils.toString(is, ENCODING);
    }

    public static String toString(InputStream is, String defaultCharset) throws IOException {
        return OAuthSafeUtil.toString(is, defaultCharset);
    }

    public static OAuthProblemException handleOAuthProblemException(String message) {
        return OAuthProblemException.error("invalid_request").description(message).responseStatus(400);
    }

    public static OAuthProblemException handleMissingParameters(Set<String> missingParams) {
        StringBuilder stringBuilder = new StringBuilder("Missing parameters: ");
        if (!OAuthUtils.isEmpty(missingParams)) {
            for (String string : missingParams) {
                stringBuilder.append(string).append(" ");
            }
        }
        return OAuthUtils.handleOAuthProblemException(stringBuilder.toString().trim());
    }

    public static OAuthProblemException handleBadContentTypeException(String expectedContentType) {
        StringBuilder stringBuilder = new StringBuilder("Bad request content type. Expecting: ").append(expectedContentType);
        return OAuthUtils.handleOAuthProblemException(stringBuilder.toString());
    }

    public static OAuthProblemException handleNotAllowedParametersOAuthException(List<String> notAllowedParams) {
        StringBuilder stringBuilder = new StringBuilder("Not allowed parameters: ");
        if (notAllowedParams != null) {
            for (String string : notAllowedParams) {
                stringBuilder.append(string).append(" ");
            }
        }
        return OAuthUtils.handleOAuthProblemException(stringBuilder.toString().trim());
    }

    public static Map<String, Object> decodeForm(String form) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (!OAuthUtils.isEmpty(form)) {
            for (String string : form.split("\\&")) {
                String string2;
                String string3;
                int n = string.indexOf(61);
                if (n < 0) {
                    string3 = OAuthUtils.decodePercent(string);
                    string2 = null;
                } else {
                    string3 = OAuthUtils.decodePercent(string.substring(0, n));
                    string2 = OAuthUtils.decodePercent(string.substring(n + 1));
                }
                hashMap.put(string3, string2);
            }
        }
        return hashMap;
    }

    public static boolean isFormEncoded(String contentType) {
        if (contentType == null) {
            return false;
        }
        int n = contentType.indexOf(";");
        if (n >= 0) {
            contentType = contentType.substring(0, n);
        }
        return "application/x-www-form-urlencoded".equalsIgnoreCase(contentType.trim());
    }

    public static String decodePercent(String s) {
        try {
            return URLDecoder.decode(s, ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static String percentEncode(String s) {
        if (s == null) {
            return "";
        }
        try {
            return URLEncoder.encode(s, ENCODING).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private static boolean isEmpty(Set<String> missingParams) {
        return missingParams == null || missingParams.size() == 0;
    }

    public static <T> T instantiateClass(Class<T> clazz) throws OAuthSystemException {
        return OAuthUtils.instantiateClassWithParameters(clazz, null, null);
    }

    public static <T> T instantiateClassWithParameters(Class<T> clazz, Class<?>[] paramsTypes, Object[] paramValues) throws OAuthSystemException {
        try {
            if (paramsTypes != null && paramValues != null) {
                if (paramsTypes.length != paramValues.length) {
                    throw new IllegalArgumentException("Number of types and values must be equal");
                }
                if (paramsTypes.length == 0 && paramValues.length == 0) {
                    return clazz.newInstance();
                }
                Constructor<T> constructor = clazz.getConstructor(paramsTypes);
                return constructor.newInstance(paramValues);
            }
            return clazz.newInstance();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new OAuthSystemException(noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            throw new OAuthSystemException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new OAuthSystemException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new OAuthSystemException(invocationTargetException);
        }
    }

    public static String getAuthHeaderField(String authHeader) {
        Matcher matcher;
        if (authHeader != null && (matcher = OAUTH_HEADER.matcher(authHeader)).matches() && AUTH_SCHEME.equalsIgnoreCase(matcher.group(1))) {
            return matcher.group(2);
        }
        return null;
    }

    public static Map<String, String> decodeOAuthHeader(String header) {
        Matcher matcher;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (header != null && (matcher = OAUTH_HEADER.matcher(header)).matches() && AUTH_SCHEME.equalsIgnoreCase(matcher.group(1))) {
            for (String string : matcher.group(2).split("\\s*,\\s*")) {
                matcher = NVP.matcher(string);
                if (!matcher.matches()) continue;
                String string2 = OAuthUtils.decodePercent(matcher.group(1));
                String string3 = OAuthUtils.decodePercent(matcher.group(2));
                hashMap.put(string2, string3);
            }
        }
        return hashMap;
    }

    public static String[] decodeClientAuthenticationHeader(String authenticationHeader) {
        if (OAuthUtils.isEmpty(authenticationHeader)) {
            return null;
        }
        String[] stringArray = authenticationHeader.split(" ");
        if (stringArray.length != 2) {
            return null;
        }
        String string = stringArray[0];
        if (!"basic".equalsIgnoreCase(string)) {
            return null;
        }
        String string2 = stringArray[1];
        return OAuthUtils.decodeBase64EncodedCredentials(string2);
    }

    private static String[] decodeBase64EncodedCredentials(String encodedCreds) {
        String string = null;
        try {
            string = new String(Base64.decodeBase64((String)encodedCreds), ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        String[] stringArray = string.split(":", 2);
        if (stringArray.length != 2) {
            return null;
        }
        if (!OAuthUtils.isEmpty(stringArray[0]) && !OAuthUtils.isEmpty(stringArray[1])) {
            return stringArray;
        }
        return null;
    }

    public static String encodeOAuthHeader(Map<String, Object> entries) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AUTH_SCHEME).append(" ");
        if (entries.get("realm") != null) {
            String string = String.valueOf(entries.get("realm"));
            if (!OAuthUtils.isEmpty(string)) {
                stringBuffer.append("realm=\"");
                stringBuffer.append(string);
                stringBuffer.append("\",");
            }
            entries.remove("realm");
        }
        for (Map.Entry entry : entries.entrySet()) {
            String string;
            String string2 = string = entry.getValue() == null ? null : String.valueOf(entry.getValue());
            if (OAuthUtils.isEmpty((String)entry.getKey()) || OAuthUtils.isEmpty(string)) continue;
            stringBuffer.append((String)entry.getKey());
            stringBuffer.append("=\"");
            stringBuffer.append(string);
            stringBuffer.append("\",");
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1);
    }

    public static String encodeAuthorizationBearerHeader(Map<String, Object> entries) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(AUTH_SCHEME).append(" ");
        for (Map.Entry<String, Object> entry : entries.entrySet()) {
            String string;
            String string2 = string = entry.getValue() == null ? null : String.valueOf(entry.getValue());
            if (OAuthUtils.isEmpty(entry.getKey()) || OAuthUtils.isEmpty(string)) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static boolean isEmpty(String value) {
        return value == null || "".equals(value);
    }

    public static boolean hasEmptyValues(String[] array) {
        if (array == null || array.length == 0) {
            return true;
        }
        for (String string : array) {
            if (!OAuthUtils.isEmpty(string)) continue;
            return true;
        }
        return false;
    }

    public static String getAuthzMethod(String header) {
        Matcher matcher;
        if (header != null && (matcher = OAUTH_HEADER.matcher(header)).matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static Set<String> decodeScopes(String s) {
        return OAuthSafeUtil.decodeScopes(s);
    }

    public static String encodeScopes(Set<String> s) {
        return OAuthSafeUtil.encodeScopes(s);
    }

    public static boolean isMultipart(HttpServletRequest request) {
        if (!"post".equalsIgnoreCase(request.getMethod())) {
            return false;
        }
        String string = request.getContentType();
        if (string == null) {
            return false;
        }
        return string.toLowerCase(Locale.ENGLISH).startsWith(MULTIPART);
    }

    public static boolean hasContentType(String requestContentType, String requiredContentType) {
        return OAuthSafeUtil.hasContentType(requestContentType, requiredContentType);
    }

    public static String getCookieValue(HttpServletRequest request, String cookieName) {
        return OAuthSafeUtil.getCookieValue(request, cookieName);
    }
}

