/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.oauth2.altu.oauth2.rs.request;

import cn.aotcloud.oauth2.altu.oauth2.common.OAuth;
import cn.aotcloud.oauth2.altu.oauth2.common.exception.OAuthProblemException;
import cn.aotcloud.oauth2.altu.oauth2.common.exception.OAuthSystemException;
import cn.aotcloud.oauth2.altu.oauth2.common.message.types.ParameterStyle;
import cn.aotcloud.oauth2.altu.oauth2.common.utils.OAuthUtils;
import cn.aotcloud.oauth2.altu.oauth2.common.validators.OAuthValidator;
import cn.aotcloud.oauth2.altu.oauth2.rs.II11iIiI;
import cn.aotcloud.oauth2.altu.oauth2.rs.extractor.TokenExtractor;
import cn.aotcloud.oauth2.altu.oauth2.rs.i111IiI1;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class OAuthAccessResourceRequest {
    private static final Map<cn.aotcloud.oauth2.altu.oauth2.common.message.types.i111IiI1, i111IiI1> tokens = new HashMap<cn.aotcloud.oauth2.altu.oauth2.common.message.types.i111IiI1, i111IiI1>();
    private HttpServletRequest request;
    private ParameterStyle[] parameterStyles = new ParameterStyle[]{OAuth.DEFAULT_PARAMETER_STYLE};
    private cn.aotcloud.oauth2.altu.oauth2.common.message.types.i111IiI1[] tokenTypes = new cn.aotcloud.oauth2.altu.oauth2.common.message.types.i111IiI1[]{OAuth.DEFAULT_TOKEN_TYPE};
    private ParameterStyle usedParameterStyle;
    private i111IiI1 usedResourceServer;
    private TokenExtractor extractor;

    public OAuthAccessResourceRequest(HttpServletRequest request) throws OAuthSystemException, OAuthProblemException {
        this(false, request, new cn.aotcloud.oauth2.altu.oauth2.common.message.types.i111IiI1[]{OAuth.DEFAULT_TOKEN_TYPE}, new ParameterStyle[]{OAuth.DEFAULT_PARAMETER_STYLE});
    }

    public OAuthAccessResourceRequest(HttpServletRequest request, ParameterStyle ... parameterStyles) throws OAuthSystemException, OAuthProblemException {
        this(false, request, new cn.aotcloud.oauth2.altu.oauth2.common.message.types.i111IiI1[]{OAuth.DEFAULT_TOKEN_TYPE}, parameterStyles);
    }

    public OAuthAccessResourceRequest(boolean checkMutilToken, HttpServletRequest request, ParameterStyle ... parameterStyles) throws OAuthSystemException, OAuthProblemException {
        this(checkMutilToken, request, new cn.aotcloud.oauth2.altu.oauth2.common.message.types.i111IiI1[]{OAuth.DEFAULT_TOKEN_TYPE}, parameterStyles);
    }

    public OAuthAccessResourceRequest(HttpServletRequest request, cn.aotcloud.oauth2.altu.oauth2.common.message.types.i111IiI1 ... tokenTypes) throws OAuthSystemException, OAuthProblemException {
        this(false, request, tokenTypes, new ParameterStyle[]{OAuth.DEFAULT_PARAMETER_STYLE});
    }

    public OAuthAccessResourceRequest(boolean checkMutilToken, HttpServletRequest request, cn.aotcloud.oauth2.altu.oauth2.common.message.types.i111IiI1[] tokenTypes, ParameterStyle[] parameterStyles) throws OAuthSystemException, OAuthProblemException {
        tokens.put(cn.aotcloud.oauth2.altu.oauth2.common.message.types.i111IiI1.II11iIiI, new II11iIiI());
        this.request = request;
        this.tokenTypes = tokenTypes != null && tokenTypes.length > 0 ? Arrays.copyOf(tokenTypes, tokenTypes.length) : tokenTypes;
        this.parameterStyles = parameterStyles != null && parameterStyles.length > 0 ? Arrays.copyOf(parameterStyles, parameterStyles.length) : parameterStyles;
        this.validate(checkMutilToken);
    }

    public String getAccessToken() throws OAuthSystemException {
        return this.extractor.getAccessToken(this.request);
    }

    /*
     * WARNING - void declaration
     */
    private void validate(boolean checkMutilToken) throws OAuthSystemException, OAuthProblemException {
        boolean bl = false;
        OAuthProblemException oAuthProblemException = null;
        String string = "OAuth parameters were not found";
        LinkedHashMap<ParameterStyle, i111IiI1> linkedHashMap = new LinkedHashMap<ParameterStyle, i111IiI1>();
        for (cn.aotcloud.oauth2.altu.oauth2.common.message.types.i111IiI1 i111IiI12 : this.tokenTypes) {
            i111IiI1 i111IiI13 = OAuthAccessResourceRequest.instantiateResourceServer(i111IiI12);
            for (ParameterStyle parameterStyle : this.parameterStyles) {
                try {
                    OAuthValidator<HttpServletRequest> oAuthValidator = i111IiI13.II11iIiI(parameterStyle);
                    oAuthValidator.validateContentType(this.request);
                    oAuthValidator.validateMethod(this.request);
                    oAuthValidator.validateRequiredParameters(this.request);
                    linkedHashMap.put(parameterStyle, i111IiI13);
                }
                catch (OAuthProblemException oAuthProblemException2) {
                    if (OAuthUtils.isEmpty(oAuthProblemException2.getError())) {
                        bl = true;
                        string = oAuthProblemException2.getDescription();
                        continue;
                    }
                    oAuthProblemException = OAuthProblemException.error(oAuthProblemException2.getError(), oAuthProblemException2.getDescription());
                }
            }
        }
        Object var6_7 = null;
        if (linkedHashMap.size() > 1) {
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                void var6_8;
                TokenExtractor tokenExtractor = ((i111IiI1)entry.getValue()).I111ii1I((ParameterStyle)((Object)entry.getKey()));
                if (var6_8 == null) {
                    String string2 = tokenExtractor.getAccessToken(this.request);
                    continue;
                }
                if (!checkMutilToken || StringUtils.equals((CharSequence)var6_8, (CharSequence)tokenExtractor.getAccessToken(this.request))) continue;
                throw OAuthProblemException.error("invalid_request", "\u53d1\u73b0\u591a\u4e2a\u4e0d\u540c\u7684\u8bbf\u95ee\u4ee4\u724c\u3002");
            }
        }
        if (linkedHashMap.isEmpty() && bl) {
            throw OAuthProblemException.error("invalid_request", string);
        }
        if (linkedHashMap.isEmpty()) {
            if (oAuthProblemException != null) {
                throw oAuthProblemException;
            }
            throw OAuthProblemException.error("invalid_request", "OAuth parameters were not found");
        }
        this.usedParameterStyle = (ParameterStyle)((Object)linkedHashMap.entrySet().iterator().next().getKey());
        this.usedResourceServer = (i111IiI1)linkedHashMap.entrySet().iterator().next().getValue();
        this.extractor = this.usedResourceServer.I111ii1I(this.usedParameterStyle);
    }

    public static i111IiI1 instantiateResourceServer(cn.aotcloud.oauth2.altu.oauth2.common.message.types.i111IiI1 tokenType) throws OAuthSystemException {
        i111IiI1 i111IiI12 = tokens.get((Object)tokenType);
        if (i111IiI12 == null) {
            throw new OAuthSystemException("Cannot instantiate a resource server.");
        }
        return i111IiI12;
    }
}

