/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.oauth2.altu.oauth2.support;

import cn.aotcloud.logger.LoggerHandle;
import cn.aotcloud.oauth2.altu.oauth2.common.exception.OAuthProblemException;
import cn.aotcloud.oauth2.altu.oauth2.rsfilter.OAuthDecision;
import cn.aotcloud.oauth2.altu.oauth2.rsfilter.OAuthRSProvider;
import cn.aotcloud.oauth2.altu.oauth2.rsfilter.SimpleOAuthClient;
import cn.aotcloud.oauth2.altu.oauth2.rsfilter.SimpleOAuthDecision;
import cn.aotcloud.oauth2.altu.oauth2.rsfilter.SimplePrincipal;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpHeaders;

public abstract class AbstractOAuthRSProvider
implements OAuthRSProvider {
    private static final String[] UID_ATTR_NAME = new String[]{"id", "userid", "userId", "username"};
    protected LoggerHandle logger = new LoggerHandle(this.getClass());

    @Override
    public OAuthDecision validateRequest(String rsId, String token, HttpServletRequest req) throws OAuthProblemException {
        return this.doValidateRequest(rsId, token, req);
    }

    protected abstract OAuthDecision doValidateRequest(String var1, String var2, HttpServletRequest var3) throws OAuthProblemException;

    protected OAuthDecision createOAuthDecision(String token, HttpHeaders headers, Map<String, Object> map) {
        String string = headers.getFirst("x-oauth-clientid");
        String string2 = this.getUid(map);
        SimpleOAuthDecision simpleOAuthDecision = new SimpleOAuthDecision();
        simpleOAuthDecision.setAuthorized(true);
        simpleOAuthDecision.setOAuthClient(new SimpleOAuthClient(string));
        simpleOAuthDecision.setPrincipal(new SimplePrincipal(string2, map));
        simpleOAuthDecision.setAccessToken(token);
        return simpleOAuthDecision;
    }

    protected String getUid(Map<String, Object> map) {
        for (String string : UID_ATTR_NAME) {
            Object object = map.get(string);
            if (object == null) continue;
            return object.toString();
        }
        return null;
    }

    protected OAuthDecision createOAuthDecision(String token, Map<String, Object> map) {
        JSONObject jSONObject = new JSONObject(map);
        JSONObject jSONObject2 = jSONObject.getJSONObject("OAuthClient");
        JSONObject jSONObject3 = jSONObject.getJSONObject("principal");
        SimpleOAuthDecision simpleOAuthDecision = new SimpleOAuthDecision();
        simpleOAuthDecision.setAuthorized(true);
        simpleOAuthDecision.setOAuthClient(jSONObject2 != null ? new SimpleOAuthClient(jSONObject2.getString("clientId")) : null);
        simpleOAuthDecision.setPrincipal(jSONObject3 != null ? new SimplePrincipal(jSONObject3.getString("id")) : null);
        simpleOAuthDecision.setAccessToken(token);
        return simpleOAuthDecision;
    }
}

