/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.redis;

import cn.aotcloud.exception.BaseExceptionEmpty;
import cn.aotcloud.exception.ExceptionUtil;
import cn.aotcloud.prop.RedisSafeProperties;
import cn.aotcloud.smcrypto.Sm3Utils;
import cn.aotcloud.smcrypto.Sm4Utils;
import cn.aotcloud.smcrypto.exception.InvalidCryptoDataException;
import cn.aotcloud.smcrypto.exception.InvalidKeyException;
import cn.aotcloud.smcrypto.exception.InvalidSourceDataException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;

public class RedisConfig {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final RedisSafeProperties redisSafeProperties;
    protected final RedisProperties redisProperties;

    public RedisConfig(RedisSafeProperties redisSafeProperties, RedisProperties redisProperties) {
        this.redisSafeProperties = redisSafeProperties;
        this.redisProperties = redisProperties;
    }

    public LettuceConnectionFactory lettuceConnectionFactory(String sm4K, String sm4v, String salt) {
        RedisStandaloneConfiguration redisStandaloneConfiguration;
        String string = this.getHost(sm4K, sm4v, salt);
        String string2 = this.getUsername(sm4K, sm4v, salt);
        String string3 = this.getPassword(sm4K, sm4v, salt);
        GenericObjectPoolConfig genericObjectPoolConfig = null;
        LettucePoolingClientConfiguration lettucePoolingClientConfiguration = null;
        RedisProperties.Lettuce lettuce = this.redisProperties.getLettuce();
        if (lettuce != null) {
            redisStandaloneConfiguration = this.redisProperties.getLettuce().getPool();
            if (redisStandaloneConfiguration != null) {
                genericObjectPoolConfig = new GenericObjectPoolConfig();
                genericObjectPoolConfig.setMaxIdle(redisStandaloneConfiguration.getMaxIdle());
                genericObjectPoolConfig.setMinIdle(redisStandaloneConfiguration.getMinIdle());
                genericObjectPoolConfig.setMaxTotal(redisStandaloneConfiguration.getMaxActive());
                if (redisStandaloneConfiguration.getMaxWait() != null) {
                    genericObjectPoolConfig.setMaxWaitMillis(redisStandaloneConfiguration.getMaxWait().getSeconds() * 1000L);
                }
                if (redisStandaloneConfiguration.getTimeBetweenEvictionRuns() != null) {
                    genericObjectPoolConfig.setTimeBetweenEvictionRunsMillis(redisStandaloneConfiguration.getTimeBetweenEvictionRuns().getSeconds() * 1000L);
                }
            }
            LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder lettucePoolingClientConfigurationBuilder = LettucePoolingClientConfiguration.builder();
            if (this.redisProperties.getTimeout() != null) {
                lettucePoolingClientConfigurationBuilder.commandTimeout(this.redisProperties.getTimeout());
            }
            if (lettuce.getShutdownTimeout() != null) {
                lettucePoolingClientConfigurationBuilder.shutdownTimeout(lettuce.getShutdownTimeout());
            }
            if (genericObjectPoolConfig != null) {
                lettucePoolingClientConfigurationBuilder.poolConfig(genericObjectPoolConfig);
            }
            lettucePoolingClientConfiguration = lettucePoolingClientConfigurationBuilder.build();
        }
        redisStandaloneConfiguration = new RedisStandaloneConfiguration();
        redisStandaloneConfiguration.setDatabase(this.redisProperties.getDatabase());
        redisStandaloneConfiguration.setHostName(string);
        redisStandaloneConfiguration.setPort(this.redisProperties.getPort());
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            redisStandaloneConfiguration.setUsername(string2);
        }
        if (StringUtils.isNotBlank((CharSequence)string3)) {
            redisStandaloneConfiguration.setPassword(RedisPassword.of((String)string3));
        }
        if (lettucePoolingClientConfiguration != null) {
            return new LettuceConnectionFactory(redisStandaloneConfiguration, (LettuceClientConfiguration)lettucePoolingClientConfiguration);
        }
        return new LettuceConnectionFactory(redisStandaloneConfiguration);
    }

    public String getHost(String sm4K, String sm4v, String salt) {
        String string = this.redisSafeProperties.getDz();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            if (StringUtils.startsWith((CharSequence)string, (CharSequence)"enc(")) {
                try {
                    String string2 = StringUtils.substringBetween((String)string, (String)"enc(", (String)"|");
                    String string3 = StringUtils.substringBetween((String)string, (String)"|", (String)")");
                    string = Sm4Utils.CBC.decryptToText((String)string2, (String)sm4K, (String)sm4v);
                    if (!this.verifySm3(string, salt, string3)) {
                        throw new BaseExceptionEmpty("Redis\u5730\u5740\u88ab\u7be1\u6539");
                    }
                    this.logger.info("Redis\u5730\u5740\u89e3\u5bc6\u540e\u88c5\u8f7d\u6210\u529f");
                }
                catch (InvalidCryptoDataException invalidCryptoDataException) {
                    this.logger.error("Redis\u5730\u5740\u89e3\u5bc6\u5931\u8d25\uff1a{}", (Object)invalidCryptoDataException.getMessage());
                }
                catch (InvalidKeyException invalidKeyException) {
                    this.logger.error("Redis\u5730\u5740\u89e3\u5bc6\u5931\u8d25\uff1a{}", (Object)invalidKeyException.getMessage());
                }
            } else {
                this.logger.info("Redis\u5730\u5740\u660e\u6587\u88c5\u8f7d\u6210\u529f");
            }
            return string;
        }
        this.logger.info("Redis\u5730\u5740\u9ed8\u8ba4\u88c5\u8f7d\u6210\u529f");
        return this.redisProperties.getHost();
    }

    public String getUsername(String sm4K, String sm4v, String salt) {
        String string = this.redisSafeProperties.getUn();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            if (StringUtils.startsWith((CharSequence)string, (CharSequence)"enc(")) {
                try {
                    String string2 = StringUtils.substringBetween((String)string, (String)"enc(", (String)"|");
                    String string3 = StringUtils.substringBetween((String)string, (String)"|", (String)")");
                    string = Sm4Utils.CBC.decryptToText((String)string2, (String)sm4K, (String)sm4v);
                    if (!this.verifySm3(string, salt, string3)) {
                        throw new BaseExceptionEmpty("Redis\u7528\u6237\u540d\u88ab\u7be1\u6539");
                    }
                    this.logger.info("Redis\u7528\u6237\u540d\u89e3\u5bc6\u540e\u88c5\u8f7d\u6210\u529f");
                }
                catch (InvalidCryptoDataException invalidCryptoDataException) {
                    this.logger.error("Redis\u7528\u6237\u540d\u89e3\u5bc6\u5931\u8d25\uff1a{}", (Object)invalidCryptoDataException.getMessage());
                }
                catch (InvalidKeyException invalidKeyException) {
                    this.logger.error("Redis\u7528\u6237\u540d\u89e3\u5bc6\u5931\u8d25\uff1a{}", (Object)invalidKeyException.getMessage());
                }
            } else {
                this.logger.info("Redis\u7528\u6237\u540d\u660e\u6587\u88c5\u8f7d\u6210\u529f");
            }
            return string;
        }
        this.logger.info("Redis\u7528\u6237\u540d\u9ed8\u8ba4\u88c5\u8f7d\u6210\u529f");
        return this.redisProperties.getUsername();
    }

    public String getPassword(String sm4K, String sm4v, String salt) {
        String string = this.redisSafeProperties.getPw();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            if (StringUtils.startsWith((CharSequence)string, (CharSequence)"enc(")) {
                try {
                    String string2 = StringUtils.substringBetween((String)string, (String)"enc(", (String)"|");
                    String string3 = StringUtils.substringBetween((String)string, (String)"|", (String)")");
                    string = Sm4Utils.CBC.decryptToText((String)string2, (String)sm4K, (String)sm4v);
                    if (!this.verifySm3(string, salt, string3)) {
                        throw new BaseExceptionEmpty("Redis\u5bc6\u7801\u88ab\u7be1\u6539");
                    }
                    this.logger.info("Redis\u5bc6\u7801\u89e3\u5bc6\u540e\u88c5\u8f7d\u6210\u529f");
                }
                catch (InvalidCryptoDataException invalidCryptoDataException) {
                    this.logger.error("Redis\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25\uff1a{}", (Object)invalidCryptoDataException.getMessage());
                }
                catch (InvalidKeyException invalidKeyException) {
                    this.logger.error("Redis\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25\uff1a{}", (Object)invalidKeyException.getMessage());
                }
            } else {
                this.logger.info("Redis\u5bc6\u7801\u660e\u6587\u88c5\u8f7d\u6210\u529f");
            }
            return string;
        }
        this.logger.info("Redis\u5bc6\u7801\u9ed8\u8ba4\u88c5\u8f7d\u6210\u529f");
        return this.redisProperties.getPassword();
    }

    private boolean verifySm3(String data, String salt, String sm3) {
        try {
            String string = Sm3Utils.encryptFromText((String)(data + salt));
            return StringUtils.equals((CharSequence)sm3, (CharSequence)string);
        }
        catch (InvalidSourceDataException invalidSourceDataException) {
            this.logger.error("SM3\u8ba1\u7b97\u5f02\u5e38\uff1a{}", (Object)ExceptionUtil.getMessage(invalidSourceDataException));
            return false;
        }
    }
}

