/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.retry;

import cn.aotcloud.retry.Attempt;
import cn.aotcloud.retry.AttemptTimeLimiter;
import cn.aotcloud.retry.BlockStrategy;
import cn.aotcloud.retry.RetryListener;
import cn.aotcloud.retry.Retryer;
import cn.aotcloud.retry.StopStrategies;
import cn.aotcloud.retry.StopStrategy;
import cn.aotcloud.retry.WaitStrategies;
import cn.aotcloud.retry.WaitStrategy;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class RetryerBuilder<V> {
    private AttemptTimeLimiter<V> attemptTimeLimiter;
    private StopStrategy stopStrategy;
    private WaitStrategy waitStrategy;
    private BlockStrategy blockStrategy;
    private Predicate<Attempt<V>> rejectionPredicate = Predicates.alwaysFalse();
    private List<RetryListener> listeners = new ArrayList<RetryListener>();

    private RetryerBuilder() {
    }

    public static <V> RetryerBuilder<V> newBuilder() {
        return new RetryerBuilder<V>();
    }

    public RetryerBuilder<V> withRetryListener(@Nonnull RetryListener listener) {
        Preconditions.checkNotNull((Object)listener, (Object)"listener may not be null");
        this.listeners.add(listener);
        return this;
    }

    public RetryerBuilder<V> withWaitStrategy(@Nonnull WaitStrategy waitStrategy) throws IllegalStateException {
        Preconditions.checkNotNull((Object)waitStrategy, (Object)"waitStrategy may not be null");
        Preconditions.checkState((this.waitStrategy == null ? 1 : 0) != 0, (String)"a wait strategy has already been set %s", (Object)this.waitStrategy);
        this.waitStrategy = waitStrategy;
        return this;
    }

    public RetryerBuilder<V> withStopStrategy(@Nonnull StopStrategy stopStrategy) throws IllegalStateException {
        Preconditions.checkNotNull((Object)stopStrategy, (Object)"stopStrategy may not be null");
        Preconditions.checkState((this.stopStrategy == null ? 1 : 0) != 0, (String)"a stop strategy has already been set %s", (Object)this.stopStrategy);
        this.stopStrategy = stopStrategy;
        return this;
    }

    public RetryerBuilder<V> withBlockStrategy(@Nonnull BlockStrategy blockStrategy) throws IllegalStateException {
        Preconditions.checkNotNull((Object)blockStrategy, (Object)"blockStrategy may not be null");
        Preconditions.checkState((this.blockStrategy == null ? 1 : 0) != 0, (String)"a block strategy has already been set %s", (Object)this.blockStrategy);
        this.blockStrategy = blockStrategy;
        return this;
    }

    public RetryerBuilder<V> withAttemptTimeLimiter(@Nonnull AttemptTimeLimiter<V> attemptTimeLimiter) {
        Preconditions.checkNotNull(attemptTimeLimiter);
        this.attemptTimeLimiter = attemptTimeLimiter;
        return this;
    }

    public RetryerBuilder<V> retryIfException() {
        this.rejectionPredicate = Predicates.or(this.rejectionPredicate, new II11iIiI(Exception.class));
        return this;
    }

    public RetryerBuilder<V> retryIfRuntimeException() {
        this.rejectionPredicate = Predicates.or(this.rejectionPredicate, new II11iIiI(RuntimeException.class));
        return this;
    }

    public RetryerBuilder<V> retryIfExceptionOfType(@Nonnull Class<? extends Throwable> exceptionClass) {
        Preconditions.checkNotNull(exceptionClass, (Object)"exceptionClass may not be null");
        this.rejectionPredicate = Predicates.or(this.rejectionPredicate, new II11iIiI(exceptionClass));
        return this;
    }

    public RetryerBuilder<V> retryIfException(@Nonnull Predicate<Throwable> exceptionPredicate) {
        Preconditions.checkNotNull(exceptionPredicate, (Object)"exceptionPredicate may not be null");
        this.rejectionPredicate = Predicates.or(this.rejectionPredicate, new I111ii1I(exceptionPredicate));
        return this;
    }

    public RetryerBuilder<V> retryIfResult(@Nonnull Predicate<V> resultPredicate) {
        Preconditions.checkNotNull(resultPredicate, (Object)"resultPredicate may not be null");
        this.rejectionPredicate = Predicates.or(this.rejectionPredicate, new i111IiI1<V>(resultPredicate));
        return this;
    }

    public Retryer<V> build() {
        AttemptTimeLimiter attemptTimeLimiter = this.attemptTimeLimiter == null ? cn.aotcloud.retry.II11iIiI.II11iIiI() : this.attemptTimeLimiter;
        StopStrategy stopStrategy = this.stopStrategy == null ? StopStrategies.neverStop() : this.stopStrategy;
        WaitStrategy waitStrategy = this.waitStrategy == null ? WaitStrategies.noWait() : this.waitStrategy;
        BlockStrategy blockStrategy = this.blockStrategy == null ? cn.aotcloud.retry.I111ii1I.II11iIiI() : this.blockStrategy;
        return new Retryer(attemptTimeLimiter, stopStrategy, waitStrategy, blockStrategy, this.rejectionPredicate, this.listeners);
    }

    private static final class I111ii1I<V>
    implements Predicate<Attempt<V>> {
        private Predicate<Throwable> II11iIiI;

        public I111ii1I(Predicate<Throwable> predicate) {
            this.II11iIiI = predicate;
        }

        public boolean II11iIiI(Attempt<V> attempt) {
            if (!attempt.hasException()) {
                return false;
            }
            return this.II11iIiI.apply((Object)attempt.getExceptionCause());
        }

        public /* synthetic */ boolean apply(Object object) {
            return this.II11iIiI((Attempt)object);
        }
    }

    private static final class i111IiI1<V>
    implements Predicate<Attempt<V>> {
        private Predicate<V> II11iIiI;

        public i111IiI1(Predicate<V> predicate) {
            this.II11iIiI = predicate;
        }

        public boolean II11iIiI(Attempt<V> attempt) {
            if (!attempt.hasResult()) {
                return false;
            }
            V v = attempt.getResult();
            return this.II11iIiI.apply(v);
        }

        public /* synthetic */ boolean apply(Object object) {
            return this.II11iIiI((Attempt)object);
        }
    }

    private static final class II11iIiI<V>
    implements Predicate<Attempt<V>> {
        private Class<? extends Throwable> II11iIiI;

        public II11iIiI(Class<? extends Throwable> clazz) {
            this.II11iIiI = clazz;
        }

        public boolean II11iIiI(Attempt<V> attempt) {
            if (!attempt.hasException()) {
                return false;
            }
            return this.II11iIiI.isAssignableFrom(attempt.getExceptionCause().getClass());
        }

        public /* synthetic */ boolean apply(Object object) {
            return this.II11iIiI((Attempt)object);
        }
    }
}

