/*
 * Decompiled with CFR 0.152.
 */
package cn.belier.swagger.customer;

import cn.belier.swagger.customer.CustomerApi;
import cn.belier.swagger.customer.CustomerApiRequestHandlerProvider;
import cn.belier.swagger.customer.SwaggerCustomerApiScanner;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class CustomerApiRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final String VALUE = "value";
    private static final String BASE_PACKAGES = "basePackages";
    private static final String BASE_PACKAGE_CLASSES = "basePackageClasses";

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry registry) {
        Set<String> basePackages = this.getBasePackages(annotationMetadata);
        Set<Class<?>> customerApiClasses = this.getCustomerApiClasses(basePackages);
        AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(CustomerApiRequestHandlerProvider.class).addConstructorArgValue(customerApiClasses).getBeanDefinition();
        String beanName = StringUtils.uncapitalize((String)beanDefinition.getBeanClass().getSimpleName());
        registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
    }

    private Set<String> getBasePackages(AnnotationMetadata annotationMetadata) {
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)annotationMetadata.getAnnotationAttributes(SwaggerCustomerApiScanner.class.getName()));
        HashSet<String> basePackages = new HashSet<String>();
        assert (annotationAttributes != null);
        for (Class clazz : annotationAttributes.getClassArray(VALUE)) {
            basePackages.add(ClassUtils.getPackageName((Class)clazz));
        }
        for (String string : annotationAttributes.getStringArray(BASE_PACKAGES)) {
            if (!StringUtils.hasText((String)string)) continue;
            basePackages.add(string);
        }
        for (Class clazz : annotationAttributes.getClassArray(BASE_PACKAGE_CLASSES)) {
            basePackages.add(ClassUtils.getPackageName((Class)clazz));
        }
        if (basePackages.isEmpty() && annotationMetadata instanceof StandardAnnotationMetadata) {
            Class introspectedClass = ((StandardAnnotationMetadata)annotationMetadata).getIntrospectedClass();
            basePackages.add(ClassUtils.getPackageName((Class)introspectedClass));
        }
        return basePackages;
    }

    private Set<Class<?>> getCustomerApiClasses(Set<String> basePackages) {
        HashSet classes = Sets.newHashSet();
        for (String basePackage : basePackages) {
            Reflections reflections = new Reflections(basePackage, new Scanner[0]);
            classes.addAll(reflections.getTypesAnnotatedWith(CustomerApi.class));
        }
        return classes;
    }
}

