/*
 * Decompiled with CFR 0.152.
 */
package cn.belier.swagger.customer;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import springfox.documentation.RequestHandler;
import springfox.documentation.spi.service.RequestHandlerProvider;
import springfox.documentation.spring.web.WebMvcRequestHandler;
import springfox.documentation.spring.web.readers.operation.HandlerMethodResolver;

public class CustomerApiRequestHandlerProvider
implements RequestHandlerProvider {
    private static final Logger log = LoggerFactory.getLogger(CustomerApiRequestHandlerProvider.class);
    @Autowired
    private HandlerMethodResolver handlerMethodResolver;
    private Set<Class<?>> classes = Sets.newHashSet();

    public CustomerApiRequestHandlerProvider(Collection<Class<?>> classes) {
        if (!CollectionUtils.isEmpty(classes)) {
            this.classes.addAll(classes);
        }
    }

    public List<RequestHandler> requestHandlers() {
        ArrayList requestHandlers = Lists.newArrayList();
        for (Class<?> c : this.classes) {
            Method[] methods;
            Object bean = this.newInstance(c);
            if (bean == null) continue;
            for (Method method : methods = c.getMethods()) {
                WebMvcRequestHandler requestHandler = this.getWebMvcRequestHandler(bean, c, method);
                if (requestHandler == null) continue;
                requestHandlers.add(requestHandler);
            }
        }
        return requestHandlers;
    }

    private Object newInstance(Class c) {
        try {
            return c.newInstance();
        }
        catch (Exception e) {
            log.warn("{}\u53cd\u5c04\u521b\u5efa\u5b9e\u4f8b\u5931\u8d25\uff0c\u8bf7\u786e\u4fdd\u8be5\u7c7b\u6709\u65e0\u53c2\u6784\u9020\u5668", (Object)c);
            return null;
        }
    }

    private WebMvcRequestHandler getWebMvcRequestHandler(Object bean, Class<?> handlerType, Method method) {
        RequestMappingInfo requestMappingInfo = this.getMappingForMethod(method, handlerType);
        if (requestMappingInfo == null) {
            return null;
        }
        HandlerMethod handlerMethod = new HandlerMethod(bean, method);
        return new WebMvcRequestHandler(this.handlerMethodResolver, requestMappingInfo, handlerMethod);
    }

    private RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMappingInfo typeInfo;
        RequestMappingInfo info = this.createRequestMappingInfo(method);
        if (info != null && (typeInfo = this.createRequestMappingInfo(handlerType)) != null) {
            info = typeInfo.combine(info);
        }
        return info;
    }

    private RequestMappingInfo createRequestMappingInfo(AnnotatedElement element) {
        RequestMapping requestMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, RequestMapping.class);
        if (requestMapping == null) {
            return null;
        }
        return RequestMappingInfo.paths((String[])requestMapping.path()).methods(requestMapping.method()).params(requestMapping.params()).headers(requestMapping.headers()).consumes(requestMapping.consumes()).produces(requestMapping.produces()).mappingName(requestMapping.name()).build();
    }
}

