package cn.bestwu.generator.database

/**
 *
 * 表对应数据模型类
 *
 * @author Peter Wu
 */
data class Table(
        val catalog: String? = null,
        val schema: String? = null,
        /**
         * 表名
         */
        val tableName: String,
        /**
         * 表类型
         */
        val tableType: String,
        /**
         * 注释说明
         */
        val comment: String,
        /**
         * 主键
         */
        val primaryKeys: List<Column>,
        /**
         * 字段
         */
        val columns: List<Column>) {

    val primaryKeyNames: List<String>
        get() = primaryKeys.map { it.columnName }
}

/**
 * 字段
 *
 * @author Peter Wu
 */
data class Column(
        val tableCat: String?,
        val tableSchem: String?,
        /**
         * 数据库字段名
         */
        val columnName: String,
        /**
         * 数据库字段类型
         */
        val typeName: String,
        /**
         * 字段类型
         */
        val dataType: Int,
        /**
         * DECIMAL_DIGITS
         */
        val scale: Int,
        /**
         * 限制长度
         */
        val length: Int,
        /**
         * 注释说明
         */
        val comment: String,
        /**
         * 是否可为空
         */
        val nullable: Boolean,
        /**
         * 默认值
         */
        val defaultVal: String?,
        var autoIncrement: Boolean = false,
        var generatedColumn: Boolean = false)
