package cn.bestwu.generator.dsl

import cn.bestwu.generator.GeneratorExtension
import dsl.*

/**
 * 模板脚本
 * @author Peter Wu

 */
object Generators {

    /**
     * @param extension 配置
     * @return 结果
     */
    fun call(extension: GeneratorExtension): List<Any> {
        val results = mutableListOf<Any>()
        extension.tableNames.forEach {
            extension.use {
                try {
                    extension.generators.forEach { generator ->
                        val result = generator.call(extension, table(it))
                        if (result != null) {
                            results.add(result)
                        }
                    }
                } catch (e: Exception) {
                    println(e.message)
                }
            }
        }

        return results
    }

    /**
     * 生成字段
     */
    val field: Field
        get() = Field()
    /**
     * 生成domain
     */
    val domain: Domain
        get() = Domain()
    /**
     * 生成JPA domain
     */
    val domainJPA: DomainJPA
        get() = DomainJPA()
    /**
     * 生成 crud dao
     */
    val crudDao: CrudDao
        get() = CrudDao()

    /**
     * Mybatis
     */
    val mybatis: Mybatis
        get() = Mybatis()

}