/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.generator.dom.java;

import cn.bestwu.generator.dom.java.JavaType;
import cn.bestwu.generator.dom.java.element.CompilationUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0002J\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bH\u0002J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bH\u0002\u00a8\u0006\u000f"}, d2={"Lcn/bestwu/generator/dom/java/JavaDomUtils;", "", "()V", "calculateParameterizedTypeName", "", "compilationUnit", "Lcn/bestwu/generator/dom/java/element/CompilationUnit;", "fqjt", "Lcn/bestwu/generator/dom/java/JavaType;", "calculateTypeName", "typeDoesNotRequireImport", "", "fullyQualifiedJavaType", "typeIsAlreadyImported", "typeIsInSamePackage", "generator"})
public final class JavaDomUtils {
    public static final JavaDomUtils INSTANCE;

    @NotNull
    public final String calculateTypeName(@Nullable CompilationUnit compilationUnit, @NotNull JavaType fqjt) {
        Intrinsics.checkParameterIsNotNull((Object)fqjt, (String)"fqjt");
        if (fqjt.getTypeArguments().size() > 0) {
            return this.calculateParameterizedTypeName(compilationUnit, fqjt);
        }
        return compilationUnit == null || this.typeDoesNotRequireImport(fqjt) || this.typeIsInSamePackage(compilationUnit, fqjt) || this.typeIsAlreadyImported(compilationUnit, fqjt) ? fqjt.getShortName() : fqjt.getFullyQualifiedName();
    }

    private final String calculateParameterizedTypeName(CompilationUnit compilationUnit, JavaType fqjt) {
        String baseTypeName = this.calculateTypeName(compilationUnit, new JavaType(fqjt.getFullyQualifiedNameWithoutTypeParameters()));
        StringBuilder sb = new StringBuilder();
        sb.append(baseTypeName);
        sb.append('<');
        boolean comma = false;
        for (JavaType ft : fqjt.getTypeArguments()) {
            if (comma) {
                sb.append(", ");
            } else {
                comma = true;
            }
            sb.append(this.calculateTypeName(compilationUnit, ft));
        }
        sb.append('>');
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    private final boolean typeDoesNotRequireImport(JavaType fullyQualifiedJavaType) {
        return fullyQualifiedJavaType.isPrimitive() || !fullyQualifiedJavaType.isExplicitlyImported();
    }

    private final boolean typeIsInSamePackage(CompilationUnit compilationUnit, JavaType fullyQualifiedJavaType) {
        return Intrinsics.areEqual((Object)fullyQualifiedJavaType.getPackageName(), (Object)compilationUnit.getType().getPackageName());
    }

    /*
     * WARNING - void declaration
     */
    private final boolean typeIsAlreadyImported(CompilationUnit compilationUnit, JavaType fullyQualifiedJavaType) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)compilationUnit.getImportedTypes();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            JavaType it = (JavaType)element$iv$iv;
            Iterable list$iv$iv = it.getImportList();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return ((List)destination$iv$iv).contains(fullyQualifiedJavaType.getFullyQualifiedNameWithoutTypeParameters());
    }

    private JavaDomUtils() {
    }

    static {
        JavaDomUtils javaDomUtils;
        INSTANCE = javaDomUtils = new JavaDomUtils();
    }
}

