/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.generator.dom.java;

import cn.bestwu.generator.database.Column;
import cn.bestwu.generator.dom.java.JavaType;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0002J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcn/bestwu/generator/dom/java/JavaTypeResolver;", "", "()V", "forceBigDecimals", "", "getForceBigDecimals", "()Z", "setForceBigDecimals", "(Z)V", "typeMap", "", "", "Lcn/bestwu/generator/dom/java/JavaTypeResolver$JdbcTypeInformation;", "calculateBigDecimalReplacement", "Lcn/bestwu/generator/dom/java/JavaType;", "column", "Lcn/bestwu/generator/database/Column;", "defaultType", "calculateBitReplacement", "calculateJavaType", "calculateJdbcTypeName", "", "overrideDefaultType", "JdbcTypeInformation", "generator"})
public final class JavaTypeResolver {
    private static boolean forceBigDecimals;
    private static Map<Integer, JdbcTypeInformation> typeMap;
    public static final JavaTypeResolver INSTANCE;

    public final boolean getForceBigDecimals() {
        return forceBigDecimals;
    }

    public final void setForceBigDecimals(boolean bl) {
        forceBigDecimals = bl;
    }

    @Nullable
    public final JavaType calculateJavaType(@NotNull Column column) {
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        JavaType answer = null;
        JdbcTypeInformation jdbcTypeInformation = typeMap.get(column.getDataType());
        if (jdbcTypeInformation != null) {
            answer = jdbcTypeInformation.getJavaType();
            answer = this.overrideDefaultType(column, answer);
        }
        return answer;
    }

    @Nullable
    public final String calculateJdbcTypeName(@NotNull Column column) {
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        String answer = null;
        JdbcTypeInformation jdbcTypeInformation = typeMap.get(column.getDataType());
        if (jdbcTypeInformation != null) {
            answer = jdbcTypeInformation.getJdbcTypeName();
        }
        return answer;
    }

    private final JavaType overrideDefaultType(Column column, JavaType defaultType) {
        JavaType answer = defaultType;
        switch (column.getDataType()) {
            case -7: {
                answer = this.calculateBitReplacement(column, defaultType);
                break;
            }
            case 2: 
            case 3: {
                answer = this.calculateBigDecimalReplacement(column, defaultType);
            }
        }
        return answer;
    }

    private final JavaType calculateBitReplacement(Column column, JavaType defaultType) {
        JavaType answer;
        if (column.getLength() > 1) {
            String string = byte[].class.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ByteArray::class.java.name");
            answer = new JavaType(string);
        } else {
            answer = defaultType;
        }
        return answer;
    }

    private final JavaType calculateBigDecimalReplacement(Column column, JavaType defaultType) {
        JavaType answer;
        if (column.getScale() > 0 || column.getLength() > 20 || forceBigDecimals) {
            answer = defaultType;
        } else if (column.getLength() > 11) {
            String string = Long.class.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.Long::class.java.name");
            answer = new JavaType(string);
        } else if (column.getLength() > 4) {
            String string = Integer.class.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.Integer::class.java.name");
            answer = new JavaType(string);
        } else {
            String string = Short.class.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.Short::class.java.name");
            answer = new JavaType(string);
        }
        return answer;
    }

    private JavaTypeResolver() {
    }

    static {
        JavaTypeResolver javaTypeResolver;
        INSTANCE = javaTypeResolver = new JavaTypeResolver();
        typeMap = new HashMap();
        Map<Integer, JdbcTypeInformation> map = typeMap;
        Integer n = 2003;
        String string = Object.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.Object::class.java.name");
        JdbcTypeInformation jdbcTypeInformation = new JdbcTypeInformation("ARRAY", new JavaType(string));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = -5;
        String string2 = Long.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.Long::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("BIGINT", new JavaType(string2));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = -2;
        String string3 = byte[].class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"ByteArray::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("BINARY", new JavaType(string3));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = -7;
        String string4 = Boolean.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.Boolean::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("BIT", new JavaType(string4));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = 2004;
        String string5 = byte[].class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"ByteArray::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("BLOB", new JavaType(string5));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = 16;
        String string6 = Boolean.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"java.lang.Boolean::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("BOOLEAN", new JavaType(string6));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = 1;
        String string7 = String.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"java.lang.String::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("CHAR", new JavaType(string7));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = 2005;
        String string8 = String.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"java.lang.String::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("CLOB", new JavaType(string8));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = 70;
        String string9 = Object.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"java.lang.Object::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("DATALINK", new JavaType(string9));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = 91;
        String string10 = Date.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"Date::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("DATE", new JavaType(string10));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = 3;
        String string11 = BigDecimal.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"BigDecimal::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("DECIMAL", new JavaType(string11));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = 2001;
        String string12 = Object.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"java.lang.Object::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("DISTINCT", new JavaType(string12));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = 8;
        String string13 = Double.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"java.lang.Double::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("DOUBLE", new JavaType(string13));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = 6;
        String string14 = Double.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string14, (String)"java.lang.Double::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("FLOAT", new JavaType(string14));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = 4;
        String string15 = Integer.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string15, (String)"java.lang.Integer::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("INTEGER", new JavaType(string15));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = 2000;
        String string16 = Object.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string16, (String)"java.lang.Object::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("JAVA_OBJECT", new JavaType(string16));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = -16;
        String string17 = String.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string17, (String)"java.lang.String::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("LONGNVARCHAR", new JavaType(string17));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = -4;
        String string18 = byte[].class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string18, (String)"ByteArray::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("LONGVARBINARY", new JavaType(string18));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = -1;
        String string19 = String.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string19, (String)"java.lang.String::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("LONGVARCHAR", new JavaType(string19));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = -15;
        String string20 = String.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string20, (String)"java.lang.String::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("NCHAR", new JavaType(string20));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = 2011;
        String string21 = String.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string21, (String)"java.lang.String::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("NCLOB", new JavaType(string21));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = -9;
        String string22 = String.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string22, (String)"java.lang.String::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("NVARCHAR", new JavaType(string22));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = 0;
        String string23 = Object.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string23, (String)"java.lang.Object::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("NULL", new JavaType(string23));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = 2;
        String string24 = BigDecimal.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string24, (String)"BigDecimal::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("NUMERIC", new JavaType(string24));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = 1111;
        String string25 = Object.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string25, (String)"java.lang.Object::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("OTHER", new JavaType(string25));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = 7;
        String string26 = Float.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string26, (String)"java.lang.Float::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("REAL", new JavaType(string26));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = 2006;
        String string27 = Object.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string27, (String)"java.lang.Object::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("REF", new JavaType(string27));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = 5;
        String string28 = Short.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string28, (String)"java.lang.Short::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("SMALLINT", new JavaType(string28));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = 2002;
        String string29 = Object.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string29, (String)"java.lang.Object::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("STRUCT", new JavaType(string29));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = 92;
        String string30 = Date.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string30, (String)"Date::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("TIME", new JavaType(string30));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = 93;
        String string31 = Date.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string31, (String)"Date::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("TIMESTAMP", new JavaType(string31));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = -6;
        String string32 = Byte.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string32, (String)"java.lang.Byte::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("TINYINT", new JavaType(string32));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = -3;
        String string33 = byte[].class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string33, (String)"ByteArray::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("VARBINARY", new JavaType(string33));
        map.put(n, jdbcTypeInformation);
        map = typeMap;
        n = 12;
        String string34 = String.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string34, (String)"java.lang.String::class.java.name");
        jdbcTypeInformation = new JdbcTypeInformation("VARCHAR", new JavaType(string34));
        map.put(n, jdbcTypeInformation);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcn/bestwu/generator/dom/java/JavaTypeResolver$JdbcTypeInformation;", "", "jdbcTypeName", "", "javaType", "Lcn/bestwu/generator/dom/java/JavaType;", "(Ljava/lang/String;Lcn/bestwu/generator/dom/java/JavaType;)V", "getJavaType", "()Lcn/bestwu/generator/dom/java/JavaType;", "getJdbcTypeName", "()Ljava/lang/String;", "generator"})
    public static final class JdbcTypeInformation {
        @NotNull
        private final String jdbcTypeName;
        @NotNull
        private final JavaType javaType;

        @NotNull
        public final String getJdbcTypeName() {
            return this.jdbcTypeName;
        }

        @NotNull
        public final JavaType getJavaType() {
            return this.javaType;
        }

        public JdbcTypeInformation(@NotNull String jdbcTypeName, @NotNull JavaType javaType) {
            Intrinsics.checkParameterIsNotNull((Object)jdbcTypeName, (String)"jdbcTypeName");
            Intrinsics.checkParameterIsNotNull((Object)javaType, (String)"javaType");
            this.jdbcTypeName = jdbcTypeName;
            this.javaType = javaType;
        }
    }
}

