/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.generator.dom.java.element;

import cn.bestwu.generator.dom.java.JavaDomUtils;
import cn.bestwu.generator.dom.java.JavaType;
import cn.bestwu.generator.dom.java.element.CompilationUnit;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcn/bestwu/generator/dom/java/element/TypeParameter;", "", "name", "", "extendsTypes", "", "Lcn/bestwu/generator/dom/java/JavaType;", "(Ljava/lang/String;Ljava/util/List;)V", "getExtendsTypes", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "getFormattedContent", "compilationUnit", "Lcn/bestwu/generator/dom/java/element/CompilationUnit;", "toString", "generator"})
public final class TypeParameter {
    @NotNull
    private final String name;
    @NotNull
    private final List<JavaType> extendsTypes;

    @NotNull
    public final String getFormattedContent(@Nullable CompilationUnit compilationUnit) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (!this.extendsTypes.isEmpty()) {
            sb.append(" extends ");
            boolean addAnd = false;
            for (JavaType type : this.extendsTypes) {
                if (addAnd) {
                    sb.append(" & ");
                } else {
                    addAnd = true;
                }
                sb.append(JavaDomUtils.INSTANCE.calculateTypeName(compilationUnit, type));
            }
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public String toString() {
        return this.getFormattedContent(null);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<JavaType> getExtendsTypes() {
        return this.extendsTypes;
    }

    @JvmOverloads
    public TypeParameter(@NotNull String name, @NotNull List<? extends JavaType> extendsTypes) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(extendsTypes, (String)"extendsTypes");
        this.name = name;
        this.extendsTypes = extendsTypes;
    }

    @JvmOverloads
    public /* synthetic */ TypeParameter(String string, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = new ArrayList();
        }
        this(string, list);
    }

    @JvmOverloads
    public TypeParameter(@NotNull String name) {
        this(name, null, 2, null);
    }
}

