package com.zhipu.oapi.service.v4.assistant.message.tools.function;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Map;

/**
 * This class represents a function tool with a name, arguments, and outputs.
 */
public class FunctionTool {

    /**
     * The name of the function tool.
     */
    @JsonProperty("name")
    private String name;

    /**
     * The arguments for the function tool, which can be a string or a dictionary.
     */
    @JsonProperty("arguments")
    private JsonNode arguments;  // Union type in Java can be represented by Object, and deserialization handles it accordingly

    /**
     * A list of outputs generated by the function tool.
     */
    @JsonProperty("outputs")
    private List<FunctionToolOutput> outputs;

    // Getters and Setters

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JsonNode getArguments() {
        return arguments;
    }

    public void setArguments(JsonNode arguments) {
        this.arguments = arguments;
    }

    public List<FunctionToolOutput> getOutputs() {
        return outputs;
    }

    public void setOutputs(List<FunctionToolOutput> outputs) {
        this.outputs = outputs;
    }
}
