/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi.service.v4.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.zhipu.oapi.core.response.HttpxBinaryResponseContent;
import com.zhipu.oapi.service.v4.api.ClientBaseService;
import com.zhipu.oapi.service.v4.api.batches.BatchesApi;
import com.zhipu.oapi.service.v4.api.chat.ChatApi;
import com.zhipu.oapi.service.v4.api.embedding.EmbeddingApi;
import com.zhipu.oapi.service.v4.api.file.FileApi;
import com.zhipu.oapi.service.v4.api.fine_tuning.FineTuningApi;
import com.zhipu.oapi.service.v4.api.images.ImagesApi;
import com.zhipu.oapi.service.v4.api.tools.ToolsApi;
import com.zhipu.oapi.service.v4.batchs.Batch;
import com.zhipu.oapi.service.v4.batchs.BatchCreateParams;
import com.zhipu.oapi.service.v4.batchs.BatchPage;
import com.zhipu.oapi.service.v4.embedding.EmbeddingResult;
import com.zhipu.oapi.service.v4.file.FileDeleted;
import com.zhipu.oapi.service.v4.file.QueryFileResult;
import com.zhipu.oapi.service.v4.file.QueryFilesRequest;
import com.zhipu.oapi.service.v4.file.UploadFileRequest;
import com.zhipu.oapi.service.v4.fine_turning.FineTunedModelsStatus;
import com.zhipu.oapi.service.v4.fine_turning.FineTuningEvent;
import com.zhipu.oapi.service.v4.fine_turning.FineTuningJob;
import com.zhipu.oapi.service.v4.fine_turning.FineTuningJobRequest;
import com.zhipu.oapi.service.v4.fine_turning.PersonalFineTuningJob;
import com.zhipu.oapi.service.v4.image.ImageResult;
import com.zhipu.oapi.service.v4.model.ModelData;
import com.zhipu.oapi.service.v4.tools.WebSearchPro;
import io.reactivex.Single;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;

public class ClientApiService
extends ClientBaseService {
    private final ChatApi chatApi;
    private final BatchesApi batchesApi;
    private final EmbeddingApi embeddingApi;
    private final FileApi fileApi;
    private final FineTuningApi fineTuningApi;
    private final ImagesApi imagesApi;
    private final ToolsApi toolsApi;

    public ClientApiService(OkHttpClient client, String baseUrl) {
        super(client, baseUrl);
        this.chatApi = (ChatApi)this.retrofit.create(ChatApi.class);
        this.batchesApi = (BatchesApi)this.retrofit.create(BatchesApi.class);
        this.embeddingApi = (EmbeddingApi)this.retrofit.create(EmbeddingApi.class);
        this.fileApi = (FileApi)this.retrofit.create(FileApi.class);
        this.fineTuningApi = (FineTuningApi)this.retrofit.create(FineTuningApi.class);
        this.imagesApi = (ImagesApi)this.retrofit.create(ImagesApi.class);
        this.toolsApi = (ToolsApi)this.retrofit.create(ToolsApi.class);
    }

    public Call<ResponseBody> streamChatCompletion(Map<String, Object> request) {
        return this.chatApi.createChatCompletionStream(request);
    }

    public Single<ModelData> createChatCompletionAsync(Map<String, Object> request) {
        return this.chatApi.createChatCompletionAsync(request);
    }

    public Single<ModelData> createChatCompletion(Map<String, Object> request) {
        return this.chatApi.createChatCompletion(request);
    }

    public Single<ModelData> queryAsyncResult(String id) {
        return this.chatApi.queryAsyncResult(id);
    }

    public Single<EmbeddingResult> createEmbeddings(Map<String, Object> request) {
        return this.embeddingApi.createEmbeddings(request);
    }

    public Single<QueryFileResult> queryFileList(QueryFilesRequest queryFilesRequest) {
        return this.fileApi.queryFileList(queryFilesRequest.getAfter(), queryFilesRequest.getPurpose(), queryFilesRequest.getOrder(), queryFilesRequest.getLimit());
    }

    public HttpxBinaryResponseContent fileContent(String fileId) throws IOException {
        return this.fileWrapper(this.fileApi.fileContent(fileId));
    }

    public Single<com.zhipu.oapi.service.v4.file.File> retrieveFile(String fileId) {
        return this.fileApi.retrieveFile(fileId);
    }

    public Single<FileDeleted> deletedFile(String fileId) {
        return this.fileApi.deletedFile(fileId);
    }

    public Single<FineTuningEvent> listFineTuningJobEvents(String fineTuningJobId, Integer limit, String after) {
        return this.fineTuningApi.listFineTuningJobEvents(fineTuningJobId, limit, after);
    }

    public Single<FineTuningJob> retrieveFineTuningJob(String fineTuningJobId, Integer limit, String after) {
        return this.fineTuningApi.retrieveFineTuningJob(fineTuningJobId, limit, after);
    }

    public Single<PersonalFineTuningJob> queryPersonalFineTuningJobs(Integer limit, String after) {
        return this.fineTuningApi.queryPersonalFineTuningJobs(limit, after);
    }

    public Single<FineTuningJob> cancelFineTuningJob(String fineTuningJobId) {
        return this.fineTuningApi.cancelFineTuningJob(fineTuningJobId);
    }

    public Single<FineTuningJob> deleteFineTuningJob(String fineTuningJobId) {
        return this.fineTuningApi.deleteFineTuningJob(fineTuningJobId);
    }

    public Single<FineTunedModelsStatus> deleteFineTuningModel(String fineTunedModel) {
        return this.fineTuningApi.deleteFineTuningModel(fineTunedModel);
    }

    public Single<FineTuningJob> createFineTuningJob(FineTuningJobRequest request) {
        return this.fineTuningApi.createFineTuningJob(request);
    }

    public Single<com.zhipu.oapi.service.v4.file.File> uploadFile(UploadFileRequest request) throws JsonProcessingException {
        File file = new File(request.getFilePath());
        if (!file.exists()) {
            throw new RuntimeException("file not found");
        }
        MultipartBody.Part filePart = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file));
        MultipartBody.Builder formBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        formBodyBuilder.addPart(filePart);
        formBodyBuilder.addFormDataPart("purpose", request.getPurpose());
        if (request.getExtraJson() != null) {
            for (String s : request.getExtraJson().keySet()) {
                if (request.getExtraJson().get(s) instanceof String || request.getExtraJson().get(s) instanceof Number || request.getExtraJson().get(s) instanceof Boolean || request.getExtraJson().get(s) instanceof Character) {
                    formBodyBuilder.addFormDataPart(s, request.getExtraJson().get(s).toString());
                    continue;
                }
                if (request.getExtraJson().get(s) instanceof Date) {
                    Date date = (Date)request.getExtraJson().get(s);
                    formBodyBuilder.addFormDataPart(s, String.valueOf(date.getTime()));
                    continue;
                }
                formBodyBuilder.addFormDataPart(s, null, RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)mapper.writeValueAsString(request.getExtraJson().get(s))));
            }
        }
        MultipartBody multipartBody = formBodyBuilder.build();
        return this.fileApi.uploadFile(multipartBody);
    }

    public Single<ImageResult> createImage(Map<String, Object> request) {
        return this.imagesApi.createImage(request);
    }

    public Single<Batch> batchesCreate(BatchCreateParams batchCreateParams) {
        return this.batchesApi.batchesCreate(batchCreateParams);
    }

    public Single<Batch> batchesRetrieve(String batchId) {
        return this.batchesApi.batchesRetrieve(batchId);
    }

    public Single<BatchPage> batchesList(Integer limit, String after) {
        return this.batchesApi.batchesList(after, limit);
    }

    public Single<Batch> batchesCancel(String batchId) {
        return this.batchesApi.batchesCancel(batchId);
    }

    public Call<ResponseBody> webSearchProStreaming(Map<String, Object> request) {
        return this.toolsApi.webSearchStreaming(request);
    }

    public Single<WebSearchPro> webSearchPro(Map<String, Object> request) {
        return this.toolsApi.webSearch(request);
    }

    private HttpxBinaryResponseContent fileWrapper(Call<ResponseBody> response) throws IOException {
        Response execute = response.execute();
        if (!execute.isSuccessful() || execute.body() == null) {
            throw new IOException("Failed to get the file content");
        }
        return new HttpxBinaryResponseContent((Response<ResponseBody>)execute);
    }
}

