/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi.service.v4.api;

import com.zhipu.oapi.ClientV4;
import com.zhipu.oapi.core.model.ClientRequest;
import com.zhipu.oapi.service.v4.api.ClientBaseService;
import com.zhipu.oapi.service.v4.api.GenerationChain;
import com.zhipu.oapi.service.v4.api.knowledge.KnowledgeApi;
import com.zhipu.oapi.service.v4.knowledge.KnowledgeBaseParams;
import com.zhipu.oapi.service.v4.knowledge.KnowledgeEditResponse;
import com.zhipu.oapi.service.v4.knowledge.KnowledgeInfo;
import com.zhipu.oapi.service.v4.knowledge.KnowledgePage;
import com.zhipu.oapi.service.v4.knowledge.KnowledgeResponse;
import com.zhipu.oapi.service.v4.knowledge.KnowledgeUsed;
import com.zhipu.oapi.service.v4.knowledge.KnowledgeUsedResponse;
import com.zhipu.oapi.service.v4.knowledge.QueryKnowledgeApiResponse;
import com.zhipu.oapi.service.v4.knowledge.QueryKnowledgeRequest;
import com.zhipu.oapi.utils.RequestSupplier;
import io.reactivex.Single;
import okhttp3.OkHttpClient;
import retrofit2.Response;

public class KnowledgeClientApiService
extends ClientBaseService {
    private final KnowledgeApi knowledgeApi;

    public KnowledgeClientApiService(OkHttpClient client, String baseUrl) {
        super(client, baseUrl);
        this.knowledgeApi = (KnowledgeApi)this.retrofit.create(KnowledgeApi.class);
    }

    public KnowledgeGenerationChain knowledgeCreate(KnowledgeBaseParams params) {
        Single<KnowledgeInfo> single = this.knowledgeApi.knowledgeCreate(params);
        return new KnowledgeGenerationChain(params, single);
    }

    public KnowledgeEditGenerationChain knowledgeModify(KnowledgeBaseParams params) {
        Single<Response<Void>> single = this.knowledgeApi.knowledgeModify(params.getKnowledgeId(), params);
        return new KnowledgeEditGenerationChain(params, single);
    }

    public KnowledgePageGenerationChain knowledgeQuery(QueryKnowledgeRequest params) {
        Single<KnowledgePage> knowledgePageSingle = this.knowledgeApi.knowledgeQuery(params.getPage(), params.getSize());
        return new KnowledgePageGenerationChain(params, knowledgePageSingle);
    }

    public KnowledgeEditGenerationChain knowledgeDelete(KnowledgeBaseParams params) {
        Single<Response<Void>> knowledgePageSingle = this.knowledgeApi.knowledgeDelete(params.getKnowledgeId());
        return new KnowledgeEditGenerationChain(params, knowledgePageSingle);
    }

    public KnowledgeUsedGenerationChain knowledgeUsed() {
        Single<KnowledgeUsed> knowledgeUsedSingle = this.knowledgeApi.knowledgeUsed();
        return new KnowledgeUsedGenerationChain(knowledgeUsedSingle);
    }

    public static class KnowledgeUsedGenerationChain
    extends GenerationChain<KnowledgeUsed, KnowledgeUsedResponse> {
        private final Single<KnowledgeUsed> objectSingle;

        public KnowledgeUsedGenerationChain(Single<KnowledgeUsed> objectSingle) {
            this.objectSingle = objectSingle;
        }

        @Override
        public KnowledgeUsedResponse apply(ClientV4 clientV4) {
            RequestSupplier supplier = params -> this.objectSingle;
            ClientRequest<Object> params2 = () -> "null";
            return clientV4.executeRequest(params2, supplier, KnowledgeUsedResponse.class);
        }
    }

    public static class KnowledgePageGenerationChain
    extends GenerationChain<KnowledgePage, QueryKnowledgeApiResponse> {
        private final QueryKnowledgeRequest params;
        private final Single<KnowledgePage> objectSingle;

        public KnowledgePageGenerationChain(QueryKnowledgeRequest params, Single<KnowledgePage> objectSingle) {
            this.params = params;
            this.objectSingle = objectSingle;
        }

        @Override
        public QueryKnowledgeApiResponse apply(ClientV4 clientV4) {
            RequestSupplier supplier = params -> this.objectSingle;
            return clientV4.executeRequest(this.params, supplier, QueryKnowledgeApiResponse.class);
        }
    }

    public static class KnowledgeEditGenerationChain
    extends GenerationChain<Response<Void>, KnowledgeEditResponse> {
        private final KnowledgeBaseParams params;
        private final Single<Response<Void>> objectSingle;

        public KnowledgeEditGenerationChain(KnowledgeBaseParams params, Single<Response<Void>> objectSingle) {
            this.params = params;
            this.objectSingle = objectSingle;
        }

        @Override
        public KnowledgeEditResponse apply(ClientV4 clientV4) {
            RequestSupplier supplier = params -> this.objectSingle;
            return clientV4.executeRequest(this.params, supplier, KnowledgeEditResponse.class);
        }
    }

    public static class KnowledgeGenerationChain
    extends GenerationChain<KnowledgeInfo, KnowledgeResponse> {
        private final KnowledgeBaseParams params;
        private final Single<KnowledgeInfo> objectSingle;

        public KnowledgeGenerationChain(KnowledgeBaseParams params, Single<KnowledgeInfo> objectSingle) {
            this.params = params;
            this.objectSingle = objectSingle;
        }

        @Override
        public KnowledgeResponse apply(ClientV4 clientV4) {
            RequestSupplier supplier = params -> this.objectSingle;
            return clientV4.executeRequest(this.params, supplier, KnowledgeResponse.class);
        }
    }
}

