/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi.service.v4.deserialize.assistant.message.tools;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zhipu.oapi.service.v4.assistant.message.tools.ToolsType;
import com.zhipu.oapi.service.v4.deserialize.JsonTypeField;
import com.zhipu.oapi.service.v4.deserialize.JsonTypeMapping;
import java.io.IOException;
import java.lang.reflect.Field;

public class ToolsTypeDeserializer
extends JsonDeserializer<ToolsType> {
    public ToolsType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.readValueAsTree();
        JsonTypeMapping mapping = ToolsType.class.getAnnotation(JsonTypeMapping.class);
        if (mapping == null) {
            throw new IllegalStateException("Missing JsonTypeMapping annotation on MessageContent class");
        }
        for (Class<?> clazz : mapping.value()) {
            JsonTypeField typeField = clazz.getAnnotation(JsonTypeField.class);
            if (typeField == null || !node.has(typeField.value())) continue;
            try {
                Object obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                for (Field field : clazz.getDeclaredFields()) {
                    field.setAccessible(true);
                    JsonProperty annotation = field.getAnnotation(JsonProperty.class);
                    String name = null;
                    name = annotation == null ? field.getName() : annotation.value();
                    if (!node.has(name)) continue;
                    if (field.getType().equals(String.class)) {
                        field.set(obj, node.get(name).asText());
                        continue;
                    }
                    if (field.getType().equals(Integer.TYPE) || field.getType().equals(Integer.class)) {
                        field.set(obj, node.get(name).asInt());
                        continue;
                    }
                    if (field.getType().equals(Boolean.TYPE) || field.getType().equals(Boolean.class)) {
                        field.set(obj, node.get(name).asBoolean());
                        continue;
                    }
                    Object o = new ObjectMapper().treeToValue((TreeNode)node.get(name), field.getType());
                    field.set(obj, o);
                }
                return (ToolsType)obj;
            }
            catch (Exception e) {
                throw new RuntimeException("Error while creating instance of " + clazz.getName(), e);
            }
        }
        throw new IllegalArgumentException("Cannot determine type for JSON: " + node.toString());
    }
}

