/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi.service.v4.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.zhipu.oapi.service.v4.model.SSE;
import com.zhipu.oapi.service.v4.model.SSEFormatException;
import com.zhipu.oapi.service.v4.model.ZhiPuAiError;
import com.zhipu.oapi.service.v4.model.ZhiPuAiHttpException;
import io.reactivex.FlowableEmitter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.HttpException;
import retrofit2.Response;

public class ResponseBodyCallback
implements Callback<ResponseBody> {
    private static final ObjectMapper mapper = new ObjectMapper();
    private FlowableEmitter<SSE> emitter;
    private boolean emitDone;

    public ResponseBodyCallback(FlowableEmitter<SSE> emitter, boolean emitDone) {
        this.emitter = emitter;
        this.emitDone = emitDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
        BufferedReader reader = null;
        try {
            String line;
            if (!response.isSuccessful()) {
                HttpException e = new HttpException(response);
                ResponseBody errorBody = response.errorBody();
                if (errorBody == null) {
                    throw e;
                }
                ZhiPuAiError error = (ZhiPuAiError)mapper.readValue(errorBody.string(), ZhiPuAiError.class);
                throw new ZhiPuAiHttpException(error, (Exception)e, e.code());
            }
            InputStream in = ((ResponseBody)response.body()).byteStream();
            reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            SSE sse = null;
            while (!this.emitter.isCancelled() && (line = reader.readLine()) != null) {
                if (line.startsWith("data:")) {
                    String data = line.substring(5).trim();
                    sse = new SSE(data);
                    continue;
                }
                if (line.equals("") && sse != null) {
                    if (sse.isDone()) {
                        if (!this.emitDone) break;
                        this.emitter.onNext((Object)sse);
                        break;
                    }
                    this.emitter.onNext((Object)sse);
                    sse = null;
                    continue;
                }
                throw new SSEFormatException("Invalid sse format! " + line);
            }
            this.emitter.onComplete();
        }
        catch (Throwable t) {
            this.onFailure(call, t);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException in) {}
            }
        }
    }

    public void onFailure(Call<ResponseBody> call, Throwable t) {
        this.emitter.onError(t);
    }
}

