/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi.utils;

import com.zhipu.oapi.core.ConfigV4;
import com.zhipu.oapi.core.token.AuthenticationInterceptor;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class OkHttps {
    public static OkHttpClient create(ConfigV4 config) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().addInterceptor((Interceptor)new AuthenticationInterceptor(config));
        if (config.getRequestTimeOut() > 0) {
            builder.callTimeout((long)config.getRequestTimeOut(), config.getTimeOutTimeUnit());
        } else {
            builder.callTimeout(30L, TimeUnit.SECONDS);
        }
        if (config.getConnectTimeout() > 0) {
            builder.connectTimeout((long)config.getConnectTimeout(), config.getTimeOutTimeUnit());
        } else {
            builder.connectTimeout(10L, TimeUnit.SECONDS);
        }
        if (config.getReadTimeout() > 0) {
            builder.readTimeout((long)config.getReadTimeout(), config.getTimeOutTimeUnit());
        } else {
            builder.readTimeout(10L, TimeUnit.SECONDS);
        }
        if (config.getWriteTimeout() > 0) {
            builder.writeTimeout((long)config.getWriteTimeout(), config.getTimeOutTimeUnit());
        } else {
            builder.writeTimeout(10L, TimeUnit.SECONDS);
        }
        if (config.getConnectionPool() != null) {
            builder.connectionPool(config.getConnectionPool());
        } else {
            builder.connectionPool(new ConnectionPool(5, 1L, TimeUnit.SECONDS));
        }
        return builder.build();
    }
}

