/*
 * Decompiled with CFR 0.152.
 */
package cn.brk2outside.common.lang.reflect;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Objects;

public class TypeUtil {
    public static ParameterizedType parameterizedType(Class<?> raw, Type ... actualTypeArguments) {
        Class<?> useOwner = raw.getEnclosingClass() == null ? null : raw.getEnclosingClass();
        return new ParameterizedTypeImpl(raw, useOwner, actualTypeArguments);
    }

    private static boolean equals(ParameterizedType p, Type t) {
        if (t instanceof ParameterizedType) {
            ParameterizedType other = (ParameterizedType)t;
            if (TypeUtil.equals(p.getRawType(), other.getRawType()) && TypeUtil.equals(p.getOwnerType(), other.getOwnerType())) {
                return TypeUtil.equals(p.getActualTypeArguments(), other.getActualTypeArguments());
            }
        }
        return false;
    }

    public static boolean equals(Type t1, Type t2) {
        if (Objects.equals(t1, t2)) {
            return true;
        }
        if (t1 instanceof ParameterizedType) {
            return TypeUtil.equals((ParameterizedType)t1, t2);
        }
        if (t1 instanceof GenericArrayType) {
            return TypeUtil.equals(t1, t2);
        }
        if (t1 instanceof WildcardType) {
            return TypeUtil.equals(t1, t2);
        }
        return false;
    }

    private static boolean equals(Type[] t1, Type[] t2) {
        if (t1.length == t2.length) {
            for (int i = 0; i < t1.length; ++i) {
                if (TypeUtil.equals(t1[i], t2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static final class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Class<?> raw;
        private final Type useOwner;
        private final Type[] typeArguments;

        private ParameterizedTypeImpl(Class<?> raw, Type useOwner, Type[] typeArguments) {
            this.raw = raw;
            this.useOwner = useOwner;
            this.typeArguments = (Type[])Arrays.copyOf(typeArguments, typeArguments.length, Type[].class);
        }

        @Override
        public Type getRawType() {
            return this.raw;
        }

        @Override
        public Type getOwnerType() {
            return this.useOwner;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof ParameterizedType && this == obj;
        }

        public int hashCode() {
            int result = 1136;
            result |= this.raw.hashCode();
            result <<= 4;
            result |= Objects.hashCode(this.useOwner);
            result <<= 8;
            return result |= Arrays.hashCode(this.typeArguments);
        }
    }
}

