/*
 * Decompiled with CFR 0.152.
 */
package cn.brk2outside.common.lang.type;

import cn.brk2outside.common.lang.StrUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class BoolUtils {
    private static final Set<String> FALSE_VALUE_SYMBOLS = new HashSet<String>(Arrays.asList("NULL", "FALSE", "F", "NO", "N", "NIL", "\u5426", "0"));
    private static final Set<String> NULL_VALUE_SYMBOLS = new HashSet<String>(Arrays.asList("", "NULL", "NIL", "UNDEFINED"));

    public static Optional<Boolean> toBoolean(Object obj) {
        return obj instanceof Boolean ? Optional.of((Boolean)obj) : Optional.ofNullable(obj).map(Object::toString).filter(StrUtil::hasWord).map(String::toUpperCase).filter(str -> !NULL_VALUE_SYMBOLS.contains(str)).map(FALSE_VALUE_SYMBOLS::contains).map(b -> b == false);
    }

    public static boolean absentAsFalse(Object obj) {
        return BoolUtils.toBoolean(obj).orElse(Boolean.FALSE);
    }

    public static boolean absentAsTrue(Object obj) {
        return BoolUtils.toBoolean(obj).orElse(Boolean.TRUE);
    }

    public static Optional<Boolean> toBooleanStrict(Object obj) {
        return obj instanceof Boolean ? Optional.of((Boolean)obj) : Optional.ofNullable(obj).map(Object::toString).map(Boolean::parseBoolean);
    }
}

