/*
 * Decompiled with CFR 0.152.
 */
package cn.brk2outside.common.lang.type;

import cn.brk2outside.common.lang.StrUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateUtils {
    static Pattern DATE_PATTERN = Pattern.compile("([0-9]{2,4})-([0-9]{1,2})-([0-9]{1,2})");
    static Pattern TIME_PATTERN = Pattern.compile("([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})(.[0-9]+)?");
    static Pattern DATETIME_PATTERN = Pattern.compile("([0-9]{2,4})-([0-9]{1,2})-([0-9]{1,2})\\s+([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})(.[0-9]+)?");

    public static Optional<Date> toDate(Object obj) {
        return obj instanceof Date ? Optional.of((Date)obj) : Optional.ofNullable(obj).map(Object::toString).map(DateUtils::strToDate);
    }

    private static Date strToDate(String str) {
        if (StrUtil.hasWord(str)) {
            Calendar res = Calendar.getInstance();
            str = str.trim();
            Matcher matcher = DATETIME_PATTERN.matcher(str);
            System.out.println(matcher.groupCount());
            if (matcher.matches()) {
                int year = Integer.parseInt(matcher.group(1));
                res.set(1, year);
                int month = Integer.parseInt(matcher.group(2));
                res.set(2, month - 1);
                int dayOfMonth = Integer.parseInt(matcher.group(3));
                res.set(5, dayOfMonth);
                int hourOfDay = Integer.parseInt(matcher.group(4));
                res.set(11, hourOfDay);
                int minutes = Integer.parseInt(matcher.group(5));
                res.set(12, minutes);
                int seconds = Integer.parseInt(matcher.group(6));
                res.set(13, seconds);
                return res.getTime();
            }
            matcher = DATE_PATTERN.matcher(str);
            if (matcher.matches()) {
                int year = Integer.parseInt(matcher.group(1));
                res.set(1, year);
                int month = Integer.parseInt(matcher.group(2));
                res.set(2, month - 1);
                int dayOfMonth = Integer.parseInt(matcher.group(3));
                res.set(5, dayOfMonth);
                return res.getTime();
            }
            matcher = TIME_PATTERN.matcher(str);
            if (matcher.matches()) {
                int hourOfDay = Integer.parseInt(matcher.group(1));
                res.set(11, hourOfDay);
                int minutes = Integer.parseInt(matcher.group(2));
                res.set(12, minutes);
                int seconds = Integer.parseInt(matcher.group(3));
                res.set(13, seconds);
                return res.getTime();
            }
            if (str.matches("^[0-9]+$")) {
                return new Date(Long.parseLong(str));
            }
        }
        throw new NumberFormatException("Not a valid date string: " + str);
    }

    public static Date absentAsNow(Object obj) {
        return DateUtils.toDate(obj).orElse(new Date());
    }
}

