/*
 * Decompiled with CFR 0.152.
 */
package cn.codeforfun.migrate.core.entity.structure;

import cn.codeforfun.migrate.core.diff.Difference;
import cn.codeforfun.migrate.core.entity.structure.annotations.DbUtilProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Objects;
import org.springframework.util.ObjectUtils;

public class Key
implements Difference,
Serializable {
    private static final long serialVersionUID = 5489127924529636485L;
    public static final String FLAG_PRIMARY = "PRIMARY";
    @DbUtilProperty(value="CONSTRAINT_SCHEMA")
    private String schema;
    @DbUtilProperty(value="CONSTRAINT_NAME")
    private String name;
    @DbUtilProperty(value="TABLE_NAME")
    private String tableName;
    @DbUtilProperty(value="COLUMN_NAME")
    private String columnName;
    @DbUtilProperty(value="ORDINAL_POSITION")
    private Long ordinalPosition;
    @DbUtilProperty(value="POSITION_IN_UNIQUE_CONSTRAINT")
    private Long positionInUniqueConstraint;
    @DbUtilProperty(value="REFERENCED_TABLE_SCHEMA")
    private String referencedSchema;
    @DbUtilProperty(value="REFERENCED_TABLE_NAME")
    private String referencedTable;
    @DbUtilProperty(value="REFERENCED_COLUMN_NAME")
    private String referencedColumn;

    @Override
    @JsonIgnore
    public String getDeleteSql() {
        StringBuilder sb = new StringBuilder();
        if (FLAG_PRIMARY.equals(this.name)) {
            sb.append("ALTER TABLE `").append(this.tableName).append("` DROP PRIMARY KEY;");
        } else if (ObjectUtils.isEmpty((Object)this.referencedSchema) && ObjectUtils.isEmpty((Object)this.referencedTable) && ObjectUtils.isEmpty((Object)this.referencedColumn)) {
            sb.append("ALTER TABLE `").append(this.tableName).append("` DROP KEY `").append(this.name).append("`;");
        } else {
            sb.append("ALTER TABLE `").append(this.tableName).append("` DROP FOREIGN KEY `").append(this.name).append("`;");
        }
        return sb.toString();
    }

    @JsonIgnore
    public String getCreateTableSql() {
        StringBuilder sb = new StringBuilder();
        if (FLAG_PRIMARY.equals(this.name)) {
            sb.append("PRIMARY KEY (`").append(this.columnName).append("`),");
        } else if (ObjectUtils.isEmpty((Object)this.referencedSchema) && ObjectUtils.isEmpty((Object)this.referencedTable) && ObjectUtils.isEmpty((Object)this.referencedColumn)) {
            sb.append("UNIQUE KEY `").append(this.name).append("` (`").append(this.columnName).append("`),");
        } else {
            sb.append("KEY `").append(this.name).append("` (`").append(this.columnName).append("`),");
            sb.append("CONSTRAINT `").append(this.name).append("` ").append("FOREIGN KEY (`").append(this.columnName).append("`) ").append("REFERENCES `").append(this.referencedTable).append("` ").append("(`").append(this.referencedColumn).append("`),");
        }
        return sb.toString();
    }

    @Override
    @JsonIgnore
    public String getCreateSql() {
        StringBuilder sb = new StringBuilder();
        if (FLAG_PRIMARY.equals(this.name)) {
            sb.append("ALTER TABLE `").append(this.tableName).append("` ADD PRIMARY KEY (`").append(this.columnName).append("`);");
        } else if (ObjectUtils.isEmpty((Object)this.referencedSchema) && ObjectUtils.isEmpty((Object)this.referencedTable) && ObjectUtils.isEmpty((Object)this.referencedColumn)) {
            sb.append("ALTER TABLE `").append(this.tableName).append("` ADD UNIQUE KEY `").append(this.name).append("` (`").append(this.columnName).append("`);");
        } else {
            sb.append("ALTER TABLE `").append(this.tableName).append("` ADD KEY `").append(this.name).append("` (`").append(this.columnName).append("`); ");
            sb.append("ALTER TABLE `").append(this.tableName).append("` ADD CONSTRAINT `").append(this.name).append("` ").append("FOREIGN KEY (`").append(this.columnName).append("`) ").append("REFERENCES `").append(this.referencedTable).append("` ").append("(`").append(this.referencedColumn).append("`);");
        }
        return sb.toString();
    }

    @Override
    @JsonIgnore
    public String getUpdateSql() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Key)) {
            return false;
        }
        Key key = (Key)o;
        return Objects.equals(this.getName(), key.getName()) && Objects.equals(this.getTableName(), key.getTableName()) && Objects.equals(this.getColumnName(), key.getColumnName()) && Objects.equals(this.getOrdinalPosition(), key.getOrdinalPosition()) && Objects.equals(this.getPositionInUniqueConstraint(), key.getPositionInUniqueConstraint()) && Objects.equals(this.getReferencedSchema(), key.getReferencedSchema()) && Objects.equals(this.getReferencedTable(), key.getReferencedTable()) && Objects.equals(this.getReferencedColumn(), key.getReferencedColumn());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getTableName(), this.getColumnName(), this.getOrdinalPosition(), this.getPositionInUniqueConstraint(), this.getReferencedSchema(), this.getReferencedTable(), this.getReferencedColumn());
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Long getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public Long getPositionInUniqueConstraint() {
        return this.positionInUniqueConstraint;
    }

    public String getReferencedSchema() {
        return this.referencedSchema;
    }

    public String getReferencedTable() {
        return this.referencedTable;
    }

    public String getReferencedColumn() {
        return this.referencedColumn;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setOrdinalPosition(Long ordinalPosition) {
        this.ordinalPosition = ordinalPosition;
    }

    public void setPositionInUniqueConstraint(Long positionInUniqueConstraint) {
        this.positionInUniqueConstraint = positionInUniqueConstraint;
    }

    public void setReferencedSchema(String referencedSchema) {
        this.referencedSchema = referencedSchema;
    }

    public void setReferencedTable(String referencedTable) {
        this.referencedTable = referencedTable;
    }

    public void setReferencedColumn(String referencedColumn) {
        this.referencedColumn = referencedColumn;
    }
}

