/*
 * Decompiled with CFR 0.152.
 */
package cn.codeforfun.migrate.core.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.springframework.util.ClassUtils;

public class FileUtil {
    public static final String UTF_8 = "utf-8";
    public static final String GB_2312 = "gb2312";

    public static String getStringByClasspath(String filePath) {
        ClassLoader classLoader = FileUtil.getDefaultClassLoader();
        InputStream is = classLoader.getResourceAsStream(filePath);
        return FileUtil.toString(is);
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = ClassUtils.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(InputStream is) {
        if (is == null) {
            try {
                throw new IOException();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ByteArrayOutputStream boa = null;
        try {
            int len;
            boa = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = is.read(buffer)) != -1) {
                boa.write(buffer, 0, len);
            }
            is.close();
            boa.close();
            byte[] result = boa.toByteArray();
            String temp = new String(result);
            if (temp.contains(UTF_8)) {
                String string = new String(result, StandardCharsets.UTF_8);
                return string;
            }
            if (temp.contains(GB_2312)) {
                String string = new String(result, GB_2312);
                return string;
            }
            String string = new String(result, StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (boa != null) {
                try {
                    boa.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

