/*
 * Decompiled with CFR 0.152.
 */
package cn.codeforfun.migrate.core.diff;

import cn.codeforfun.migrate.core.diff.Difference;
import cn.codeforfun.migrate.core.entity.structure.Column;
import cn.codeforfun.migrate.core.entity.structure.Database;
import cn.codeforfun.migrate.core.entity.structure.Function;
import cn.codeforfun.migrate.core.entity.structure.Key;
import cn.codeforfun.migrate.core.entity.structure.Procedure;
import cn.codeforfun.migrate.core.entity.structure.Table;
import cn.codeforfun.migrate.core.entity.structure.Trigger;
import cn.codeforfun.migrate.core.entity.structure.View;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class DiffResult {
    private static final Logger log = LoggerFactory.getLogger(DiffResult.class);
    private Database from;
    private Database to;
    private List<String> sqlList = new ArrayList<String>();
    private List<Difference> delete = new ArrayList<Difference>();
    private List<Difference> create = new ArrayList<Difference>();
    private List<Difference> update = new ArrayList<Difference>();

    public DiffResult(Database from, Database to) {
        this.from = from;
        this.to = to;
    }

    @JsonIgnore
    public List<String> getSqlList() {
        if (!ObjectUtils.isEmpty(this.sqlList)) {
            return this.sqlList;
        }
        if (ObjectUtils.isEmpty(this.delete) && ObjectUtils.isEmpty(this.create) && ObjectUtils.isEmpty(this.update)) {
            return new ArrayList<String>();
        }
        log.debug("\u5f00\u59cb\u751f\u6210sql...");
        this.resolveDeleteSql();
        this.resolveCreateSql();
        this.resolveUpdateSql();
        log.debug("\u751f\u6210sql\u5b8c\u6210");
        log.trace("sql\u751f\u6210\u7ed3\u679c: {}", this.sqlList);
        return this.sqlList;
    }

    public void resolveDeleteSql() {
        for (Difference difference : this.delete) {
            String deleteSql;
            Difference delete;
            if (difference instanceof Table) {
                delete = (Table)difference;
                if (((Table)delete).hasForeignKey()) {
                    String deleteForeignKeySql = ((Table)delete).getDeleteForeignKeySql();
                    this.sqlList.add(deleteForeignKeySql);
                }
                deleteSql = ((Table)delete).getDeleteSql();
                this.sqlList.add(deleteSql);
                continue;
            }
            if (difference instanceof Key) {
                delete = (Key)difference;
                deleteSql = ((Key)delete).getDeleteSql();
                this.sqlList.add(deleteSql);
                continue;
            }
            if (difference instanceof Column) {
                delete = (Column)difference;
                deleteSql = ((Column)delete).getDeleteSql();
                this.sqlList.add(deleteSql);
                continue;
            }
            if (difference instanceof View) {
                delete = (View)difference;
                deleteSql = ((View)delete).getDeleteSql();
                this.sqlList.add(deleteSql);
                continue;
            }
            if (difference instanceof Function) {
                delete = (Function)difference;
                deleteSql = ((Function)delete).getDeleteSql();
                this.sqlList.add(deleteSql);
                continue;
            }
            if (difference instanceof Procedure) {
                delete = (Procedure)difference;
                deleteSql = ((Procedure)delete).getDeleteSql();
                this.sqlList.add(deleteSql);
                continue;
            }
            if (!(difference instanceof Trigger)) continue;
            delete = (Trigger)difference;
            deleteSql = ((Trigger)delete).getDeleteSql();
            this.sqlList.add(deleteSql);
        }
    }

    public void resolveCreateSql() {
        for (Difference difference : this.create) {
            String createSql;
            Difference create;
            if (difference instanceof Table) {
                create = (Table)difference;
                createSql = ((Table)create).getCreateSql();
                this.sqlList.add(createSql);
                continue;
            }
            if (difference instanceof Key) {
                create = (Key)difference;
                createSql = ((Key)create).getCreateSql();
                this.sqlList.add(createSql);
                continue;
            }
            if (difference instanceof Column) {
                create = (Column)difference;
                createSql = ((Column)create).getCreateSql();
                this.sqlList.add(createSql);
                continue;
            }
            if (difference instanceof View) {
                create = (View)difference;
                createSql = ((View)create).getCreateSql();
                this.sqlList.add(createSql);
                continue;
            }
            if (difference instanceof Function) {
                create = (Function)difference;
                createSql = ((Function)create).getCreateSql();
                this.sqlList.add(createSql);
                continue;
            }
            if (difference instanceof Procedure) {
                create = (Procedure)difference;
                createSql = ((Procedure)create).getCreateSql();
                this.sqlList.add(createSql);
                continue;
            }
            if (!(difference instanceof Trigger)) continue;
            create = (Trigger)difference;
            createSql = ((Trigger)create).getCreateSql();
            this.sqlList.add(createSql);
        }
    }

    public void resolveUpdateSql() {
        for (Difference difference : this.update) {
            String updateSql;
            String createSql;
            String deleteSql;
            Difference update;
            if (difference instanceof Key) {
                update = (Key)difference;
                deleteSql = ((Key)update).getDeleteSql();
                this.sqlList.add(deleteSql);
                createSql = ((Key)update).getCreateSql();
                this.sqlList.add(createSql);
                continue;
            }
            if (difference instanceof Column) {
                update = (Column)difference;
                updateSql = ((Column)update).getUpdateSql();
                this.sqlList.add(updateSql);
                continue;
            }
            if (difference instanceof View) {
                update = (View)difference;
                updateSql = ((View)update).getUpdateSql();
                this.sqlList.add(updateSql);
                continue;
            }
            if (difference instanceof Function) {
                update = (Function)difference;
                deleteSql = ((Function)update).getDeleteSql();
                this.sqlList.add(deleteSql);
                createSql = ((Function)update).getCreateSql();
                this.sqlList.add(createSql);
                continue;
            }
            if (difference instanceof Procedure) {
                update = (Procedure)difference;
                deleteSql = ((Procedure)update).getDeleteSql();
                this.sqlList.add(deleteSql);
                createSql = ((Procedure)update).getCreateSql();
                this.sqlList.add(createSql);
                continue;
            }
            if (!(difference instanceof Trigger)) continue;
            update = (Trigger)difference;
            deleteSql = ((Trigger)update).getDeleteSql();
            this.sqlList.add(deleteSql);
            createSql = ((Trigger)update).getCreateSql();
            this.sqlList.add(createSql);
        }
    }

    public Database getFrom() {
        return this.from;
    }

    public Database getTo() {
        return this.to;
    }

    public List<Difference> getDelete() {
        return this.delete;
    }

    public List<Difference> getCreate() {
        return this.create;
    }

    public List<Difference> getUpdate() {
        return this.update;
    }

    public void setFrom(Database from) {
        this.from = from;
    }

    public void setTo(Database to) {
        this.to = to;
    }

    public void setSqlList(List<String> sqlList) {
        this.sqlList = sqlList;
    }

    public void setDelete(List<Difference> delete) {
        this.delete = delete;
    }

    public void setCreate(List<Difference> create) {
        this.create = create;
    }

    public void setUpdate(List<Difference> update) {
        this.update = update;
    }

    public DiffResult() {
    }
}

