/*
 * Decompiled with CFR 0.152.
 */
package cn.codeforfun.migrate.core.entity.structure;

import cn.codeforfun.migrate.core.diff.Difference;
import cn.codeforfun.migrate.core.entity.structure.annotations.DbUtilProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Objects;
import org.springframework.util.ObjectUtils;

public class Column
implements Difference,
Serializable {
    private static final long serialVersionUID = -5078043863310019475L;
    public static final String FLAG_NOT_NULL = "NO";
    public static final String FLAG_DEFAULT_NULL = "YES";
    public static final String FLAG_AUTO_INCREMENT = "auto_increment";
    @DbUtilProperty(value="TABLE_SCHEMA")
    private String schema;
    @DbUtilProperty(value="TABLE_NAME")
    private String table;
    @DbUtilProperty(value="COLUMN_NAME")
    private String name;
    @DbUtilProperty(value="COLUMN_DEFAULT")
    private String defaultValue;
    @DbUtilProperty(value="IS_NULLABLE")
    private String nullable;
    @DbUtilProperty(value="DATA_TYPE")
    private String type;
    @DbUtilProperty(value="CHARACTER_MAXIMUM_LENGTH")
    private Long maxLength;
    @DbUtilProperty(value="NUMERIC_PRECISION")
    private Long numericPrecision;
    @DbUtilProperty(value="NUMERIC_SCALE")
    private Long numericScale;
    @DbUtilProperty(value="DATETIME_PRECISION")
    private Long datetimePrecision;
    @DbUtilProperty(value="CHARACTER_SET_NAME")
    private String character;
    @DbUtilProperty(value="COLLATION_NAME")
    private String collation;
    @DbUtilProperty(value="COLUMN_TYPE")
    private String columnType;
    @DbUtilProperty(value="COLUMN_KEY")
    private String columnKey;
    @DbUtilProperty(value="EXTRA")
    private String extra;
    @DbUtilProperty(value="COLUMN_COMMENT")
    private String comment;
    @DbUtilProperty(value="GENERATION_EXPRESSION")
    private String generationExpression;

    @Override
    @JsonIgnore
    public String getDeleteSql() {
        return "ALTER TABLE `" + this.table + "` DROP COLUMN `" + this.name + "`;";
    }

    @JsonIgnore
    public String getCreateTableSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("`").append(this.name).append("`").append(" ");
        sb.append(this.columnType).append(" ");
        if (!ObjectUtils.isEmpty((Object)this.collation)) {
            sb.append("COLLATE ").append(this.collation).append(" ");
        }
        if (FLAG_NOT_NULL.equals(this.nullable)) {
            sb.append("NOT NULL ");
        }
        if (!ObjectUtils.isEmpty((Object)this.defaultValue)) {
            sb.append("DEFAULT ").append(this.defaultValue).append(" ");
        } else if (FLAG_DEFAULT_NULL.equals(this.nullable)) {
            sb.append("DEFAULT NULL ");
        }
        sb.append(this.extra).append(" ");
        if (!ObjectUtils.isEmpty((Object)this.comment)) {
            sb.append("COMMENT '").append(this.comment).append("' ");
        }
        sb.append(",");
        return sb.toString();
    }

    @Override
    @JsonIgnore
    public String getCreateSql() {
        String createSql = "ALTER TABLE `" + this.table + "` ADD ";
        createSql = createSql + this.getCreateTableSql();
        createSql = createSql.substring(0, createSql.length() - 1) + ";";
        return createSql;
    }

    @Override
    @JsonIgnore
    public String getUpdateSql() {
        String createSql = "ALTER TABLE `" + this.table + "` MODIFY ";
        createSql = createSql + this.getCreateTableSql();
        createSql = createSql.substring(0, createSql.length() - 1) + ";";
        return createSql;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column column = (Column)o;
        return Objects.equals(this.getTable(), column.getTable()) && Objects.equals(this.getName(), column.getName()) && (ObjectUtils.isEmpty((Object)this.getDefaultValue()) && ObjectUtils.isEmpty((Object)column.getDefaultValue()) || Objects.equals(this.getDefaultValue(), column.getDefaultValue())) && Objects.equals(this.getNullable(), column.getNullable()) && Objects.equals(this.getType(), column.getType()) && Objects.equals(this.getMaxLength(), column.getMaxLength()) && Objects.equals(this.getNumericPrecision(), column.getNumericPrecision()) && Objects.equals(this.getNumericScale(), column.getNumericScale()) && Objects.equals(this.getDatetimePrecision(), column.getDatetimePrecision()) && Objects.equals(this.getCharacter(), column.getCharacter()) && Objects.equals(this.getCollation(), column.getCollation()) && Objects.equals(this.getColumnType(), column.getColumnType()) && Objects.equals(this.getExtra(), column.getExtra()) && Objects.equals(this.getComment(), column.getComment()) && Objects.equals(this.getGenerationExpression(), column.getGenerationExpression());
    }

    public int hashCode() {
        return Objects.hash(this.getTable(), this.getName(), this.getDefaultValue(), this.getNullable(), this.getType(), this.getMaxLength(), this.getNumericPrecision(), this.getNumericScale(), this.getDatetimePrecision(), this.getCharacter(), this.getCollation(), this.getColumnType(), this.getExtra(), this.getComment(), this.getGenerationExpression());
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getNullable() {
        return this.nullable;
    }

    public String getType() {
        return this.type;
    }

    public Long getMaxLength() {
        return this.maxLength;
    }

    public Long getNumericPrecision() {
        return this.numericPrecision;
    }

    public Long getNumericScale() {
        return this.numericScale;
    }

    public Long getDatetimePrecision() {
        return this.datetimePrecision;
    }

    public String getCharacter() {
        return this.character;
    }

    public String getCollation() {
        return this.collation;
    }

    public String getColumnType() {
        return this.columnType;
    }

    public String getColumnKey() {
        return this.columnKey;
    }

    public String getExtra() {
        return this.extra;
    }

    public String getComment() {
        return this.comment;
    }

    public String getGenerationExpression() {
        return this.generationExpression;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setNullable(String nullable) {
        this.nullable = nullable;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMaxLength(Long maxLength) {
        this.maxLength = maxLength;
    }

    public void setNumericPrecision(Long numericPrecision) {
        this.numericPrecision = numericPrecision;
    }

    public void setNumericScale(Long numericScale) {
        this.numericScale = numericScale;
    }

    public void setDatetimePrecision(Long datetimePrecision) {
        this.datetimePrecision = datetimePrecision;
    }

    public void setCharacter(String character) {
        this.character = character;
    }

    public void setCollation(String collation) {
        this.collation = collation;
    }

    public void setColumnType(String columnType) {
        this.columnType = columnType;
    }

    public void setColumnKey(String columnKey) {
        this.columnKey = columnKey;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setGenerationExpression(String generationExpression) {
        this.generationExpression = generationExpression;
    }
}

