/*
 * Decompiled with CFR 0.152.
 */
package cn.codeforfun.migrate.core.entity.structure;

import cn.codeforfun.migrate.core.diff.Difference;
import cn.codeforfun.migrate.core.entity.structure.annotations.DbUtilProperty;
import cn.codeforfun.migrate.core.utils.DbUtil;
import cn.codeforfun.migrate.core.utils.FileUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;

public class View
implements Serializable,
Difference {
    private static final long serialVersionUID = 1007279552599004329L;
    @DbUtilProperty(value="TABLE_SCHEMA")
    private String schema;
    @DbUtilProperty(value="TABLE_NAME")
    private String name;
    @DbUtilProperty(value="VIEW_DEFINITION")
    private String source;
    @DbUtilProperty(value="DEFINER")
    private String definer;
    @DbUtilProperty(value="SECURITY_TYPE")
    private String securityType;
    @DbUtilProperty(value="CHARACTER_SET_CLIENT")
    private String character;
    @DbUtilProperty(value="COLLATION_CONNECTION")
    private String collation;
    @DbUtilProperty(value="CHECK_OPTION")
    private String checkOption;
    @DbUtilProperty(value="IS_UPDATABLE")
    private String updatable;

    public static List<View> configure(Connection connection, String databaseName) throws SQLException {
        return DbUtil.getBeanList(connection, FileUtil.getStringByClasspath("sql/detail/view.sql"), View.class, databaseName);
    }

    @Override
    @JsonIgnore
    public String getCreateSql() {
        return this.getString("CREATE ");
    }

    @Override
    @JsonIgnore
    public String getUpdateSql() {
        return this.getString("CREATE OR REPLACE ");
    }

    private String getString(String type) {
        return type + "VIEW `" + this.name + "` AS " + this.source;
    }

    @Override
    @JsonIgnore
    public String getDeleteSql() {
        return "drop view `" + this.name + "`;";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof View)) {
            return false;
        }
        View view = (View)o;
        return Objects.equals(this.getName(), view.getName()) && Objects.equals(this.getSource(), view.getSource()) && Objects.equals(this.getCheckOption(), view.getCheckOption());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getSource(), this.getCheckOption());
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public String getSource() {
        return this.source;
    }

    public String getDefiner() {
        return this.definer;
    }

    public String getSecurityType() {
        return this.securityType;
    }

    public String getCharacter() {
        return this.character;
    }

    public String getCollation() {
        return this.collation;
    }

    public String getCheckOption() {
        return this.checkOption;
    }

    public String getUpdatable() {
        return this.updatable;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setDefiner(String definer) {
        this.definer = definer;
    }

    public void setSecurityType(String securityType) {
        this.securityType = securityType;
    }

    public void setCharacter(String character) {
        this.character = character;
    }

    public void setCollation(String collation) {
        this.collation = collation;
    }

    public void setCheckOption(String checkOption) {
        this.checkOption = checkOption;
    }

    public void setUpdatable(String updatable) {
        this.updatable = updatable;
    }
}

