/*
 * Decompiled with CFR 0.152.
 */
package cn.codeforfun.migrate.core;

import cn.codeforfun.migrate.core.diff.DiffResult;
import cn.codeforfun.migrate.core.entity.DatabaseInfo;
import cn.codeforfun.migrate.core.entity.structure.Database;
import cn.codeforfun.migrate.core.entity.structure.Function;
import cn.codeforfun.migrate.core.entity.structure.Key;
import cn.codeforfun.migrate.core.entity.structure.Procedure;
import cn.codeforfun.migrate.core.entity.structure.Table;
import cn.codeforfun.migrate.core.entity.structure.Trigger;
import cn.codeforfun.migrate.core.entity.structure.View;
import cn.codeforfun.migrate.core.utils.DbUtil;
import cn.codeforfun.migrate.core.utils.ObjectUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Migrate {
    private static final Logger log = LoggerFactory.getLogger(Migrate.class);
    private DatabaseInfo sourceInfo;
    private DatabaseInfo targetInfo;
    private DiffResult diff;
    private static Boolean IGNORE_CHARACTER_COMPARE = false;

    public Migrate(DatabaseInfo targetInfo) {
        this.targetInfo = targetInfo;
    }

    public Migrate(DatabaseInfo sourceInfo, DatabaseInfo targetInfo) {
        this.sourceInfo = sourceInfo;
        this.targetInfo = targetInfo;
    }

    public Migrate from(DatabaseInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
        return this;
    }

    public Migrate to(DatabaseInfo targetInfo) {
        this.targetInfo = targetInfo;
        return this;
    }

    private void compare() {
        List<Table> fromTableList = this.diff.getFrom().getTables();
        List<Table> toTableList = this.diff.getTo().getTables();
        List<Table> fromUpdateTableList = fromTableList.stream().filter(s -> toTableList.stream().anyMatch(j -> j.getName().equals(s.getName()))).collect(Collectors.toList());
        List<Table> toUpdateTableList = toTableList.stream().filter(s -> fromTableList.stream().anyMatch(j -> j.getName().equals(s.getName()))).collect(Collectors.toList());
        this.compareKey(fromUpdateTableList, toUpdateTableList);
        this.compareColumn(fromUpdateTableList, toUpdateTableList);
        this.compareTable(fromTableList, toTableList);
        this.compareView();
        this.compareFunction();
        this.compareProcedure();
        this.compareTrigger();
    }

    private void compareTrigger() {
        List<Trigger> fromTriggerList = this.diff.getFrom().getTriggers();
        List<Trigger> toTriggerList = this.diff.getTo().getTriggers();
        List deleteTriggerList = toTriggerList.stream().filter(s -> fromTriggerList.stream().noneMatch(j -> j.getName().equals(s.getName()))).collect(Collectors.toList());
        this.diff.getDelete().addAll(deleteTriggerList);
        List createTriggerList = fromTriggerList.stream().filter(s -> toTriggerList.stream().noneMatch(j -> j.getName().equals(s.getName()))).collect(Collectors.toList());
        this.diff.getCreate().addAll(createTriggerList);
        List updateTriggerList = toTriggerList.stream().map(s -> fromTriggerList.stream().filter(j -> s.getName().equals(j.getName()) && !s.equals(j)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
        this.diff.getUpdate().addAll(updateTriggerList);
    }

    private void compareProcedure() {
        List<Procedure> fromProcedureList = this.diff.getFrom().getProcedures();
        List<Procedure> toProcedureList = this.diff.getTo().getProcedures();
        List deleteProcedureList = toProcedureList.stream().filter(s -> fromProcedureList.stream().noneMatch(j -> j.getName().equals(s.getName()))).collect(Collectors.toList());
        this.diff.getDelete().addAll(deleteProcedureList);
        List createProcedureList = fromProcedureList.stream().filter(s -> toProcedureList.stream().noneMatch(j -> j.getName().equals(s.getName()))).collect(Collectors.toList());
        this.diff.getCreate().addAll(createProcedureList);
        List updateProcedureList = toProcedureList.stream().map(s -> fromProcedureList.stream().filter(j -> s.getName().equals(j.getName()) && !s.equals(j)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
        this.diff.getUpdate().addAll(updateProcedureList);
    }

    private void compareFunction() {
        List<Function> fromFunctionList = this.diff.getFrom().getFunctions();
        List<Function> toFunctionList = this.diff.getTo().getFunctions();
        List deleteFunctionList = toFunctionList.stream().filter(s -> fromFunctionList.stream().noneMatch(j -> j.getName().equals(s.getName()))).collect(Collectors.toList());
        this.diff.getDelete().addAll(deleteFunctionList);
        List createFunctionList = fromFunctionList.stream().filter(s -> toFunctionList.stream().noneMatch(j -> j.getName().equals(s.getName()))).collect(Collectors.toList());
        this.diff.getCreate().addAll(createFunctionList);
        List updateFunctionList = toFunctionList.stream().map(s -> fromFunctionList.stream().filter(j -> s.getName().equals(j.getName()) && !s.equals(j)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
        this.diff.getUpdate().addAll(updateFunctionList);
    }

    private void compareView() {
        List<View> fromViewList = this.diff.getFrom().getViews();
        List<View> toViewList = this.diff.getTo().getViews();
        List deleteViewList = toViewList.stream().filter(s -> fromViewList.stream().noneMatch(j -> j.getName().equals(s.getName()))).collect(Collectors.toList());
        this.diff.getDelete().addAll(deleteViewList);
        List createViewList = fromViewList.stream().filter(s -> toViewList.stream().noneMatch(j -> j.getName().equals(s.getName()))).collect(Collectors.toList());
        this.diff.getCreate().addAll(createViewList);
        List updateViewList = toViewList.stream().map(s -> fromViewList.stream().filter(j -> s.getName().equals(j.getName()) && !s.equals(j)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
        this.diff.getUpdate().addAll(updateViewList);
    }

    private void compareColumn(List<Table> fromUpdateTableList, List<Table> toUpdateTableList) {
        List fromColumnList = fromUpdateTableList.stream().map(Table::getColumns).flatMap(Collection::stream).collect(Collectors.toList());
        List toColumnList = toUpdateTableList.stream().map(Table::getColumns).flatMap(Collection::stream).collect(Collectors.toList());
        List deleteColumnList = toColumnList.stream().filter(s -> fromColumnList.stream().noneMatch(j -> j.getName().equals(s.getName()) && j.getTableName().equals(s.getTableName()))).collect(Collectors.toList());
        this.diff.getDelete().addAll(deleteColumnList);
        List createColumnList = fromColumnList.stream().filter(s -> toColumnList.stream().noneMatch(j -> j.getName().equals(s.getName()) && j.getTableName().equals(s.getTableName()))).collect(Collectors.toList());
        this.diff.getCreate().addAll(createColumnList);
        List updateColumnList = toColumnList.stream().map(s -> fromColumnList.stream().filter(j -> s.getName().equals(j.getName()) && s.getTableName().equals(j.getTableName()) && !s.equals(j)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
        this.diff.getUpdate().addAll(updateColumnList);
    }

    private void compareKey(List<Table> fromUpdateTableList, List<Table> toUpdateTableList) {
        List fromKeyList = fromUpdateTableList.stream().map(Table::getKeys).flatMap(Collection::stream).collect(Collectors.toList());
        List toKeyList = toUpdateTableList.stream().map(Table::getKeys).flatMap(Collection::stream).collect(Collectors.toList());
        List deleteKeyList = toKeyList.stream().filter(s -> fromKeyList.stream().noneMatch(j -> j.getName().equals(s.getName()) && j.getTableName().equals(s.getTableName()) && j.getColumnName().equals(s.getColumnName()))).collect(Collectors.toList());
        this.diff.getDelete().addAll(deleteKeyList);
        List createKeyList = fromKeyList.stream().filter(s -> toKeyList.stream().noneMatch(j -> j.getName().equals(s.getName()) && j.getTableName().equals(s.getTableName()))).collect(Collectors.toList());
        this.diff.getCreate().addAll(createKeyList);
        ArrayList<Key> updateKeyList = new ArrayList<Key>();
        for (Key fromKey : fromKeyList) {
            for (Key toKey : toKeyList) {
                if ("unique_index".equals(fromKey.getName()) && "unique_index".equals(toKey.getName()) && fromKey.getTableName().equals(toKey.getTableName()) && fromKey.getColumnName().equals(toKey.getColumnName()) && !fromKey.equals(toKey)) {
                    updateKeyList.add(fromKey);
                    continue;
                }
                if ("unique_index".equals(fromKey.getName()) || "unique_index".equals(toKey.getName()) || !fromKey.getName().equals(toKey.getName()) || !fromKey.getTableName().equals(toKey.getTableName()) || fromKey.equals(toKey)) continue;
                updateKeyList.add(fromKey);
            }
        }
        this.diff.getUpdate().addAll(updateKeyList);
    }

    private void compareTable(List<Table> fromTableList, List<Table> toTableList) {
        List deleteTableList = toTableList.stream().filter(s -> fromTableList.stream().noneMatch(j -> j.getName().equals(s.getName()))).collect(Collectors.toList());
        this.diff.getDelete().addAll(deleteTableList);
        List createTableList = fromTableList.stream().filter(s -> toTableList.stream().noneMatch(j -> j.getName().equals(s.getName()))).collect(Collectors.toList());
        this.diff.getCreate().addAll(createTableList);
    }

    public DiffResult diff() throws SQLException {
        if (this.sourceInfo == null) {
            log.error("sourceDatabase \u4e3a\u7a7a");
            throw new NullPointerException("sourceDatabase \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.targetInfo == null) {
            log.error("targetDatabase \u4e3a\u7a7a");
            throw new NullPointerException("targetDatabase \u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.sourceInfo.setIgnoreCharacterCompare(IGNORE_CHARACTER_COMPARE);
        this.targetInfo.setIgnoreCharacterCompare(IGNORE_CHARACTER_COMPARE);
        log.debug("\u5f00\u59cb\u5bf9\u6bd4\u6570\u636e\u5e93");
        Database source = new Database().init(this.sourceInfo);
        Database target = new Database().init(this.targetInfo);
        this.diff = new DiffResult(source, target);
        this.compare();
        log.debug("\u5bf9\u6bd4\u6570\u636e\u5e93\u5b8c\u6210");
        if (ObjectUtils.isEmpty(this.diff.getDelete()) && ObjectUtils.isEmpty(this.diff.getCreate()) && ObjectUtils.isEmpty(this.diff.getUpdate())) {
            log.debug("\u6570\u636e\u5e93\u7ed3\u6784\u6ca1\u6709\u53d8\u5316\u3002");
        }
        return this.diff;
    }

    public void update() throws SQLException {
        if (this.diff == null) {
            this.diff();
        }
        if (ObjectUtils.isEmpty(this.diff.getDelete()) && ObjectUtils.isEmpty(this.diff.getCreate()) && ObjectUtils.isEmpty(this.diff.getUpdate())) {
            return;
        }
        log.debug("\u5f00\u59cb\u540c\u6b65\u6570\u636e\u5e93");
        List<String> sqlList = this.diff.getSqlList();
        for (String sql : sqlList) {
            DbUtil.execute(this.diff.getTo().getConnection(), sql);
        }
        log.debug("\u6570\u636e\u5e93\u540c\u6b65\u5b8c\u6210");
    }

    public Migrate ignoreCharacterCompare() {
        IGNORE_CHARACTER_COMPARE = true;
        return this;
    }

    public List<String> showSql(DatabaseInfo info) throws SQLException {
        info.setIgnoreCharacterCompare(IGNORE_CHARACTER_COMPARE);
        Database database = new Database().init(info);
        DiffResult diff = new DiffResult();
        diff.getCreate().addAll(database.getTables());
        diff.getCreate().addAll(database.getFunctions());
        diff.getCreate().addAll(database.getProcedures());
        diff.getCreate().addAll(database.getTriggers());
        diff.getCreate().addAll(database.getViews());
        return diff.getSqlList();
    }

    public DatabaseInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public DatabaseInfo getTargetInfo() {
        return this.targetInfo;
    }

    public DiffResult getDiff() {
        return this.diff;
    }

    public void setSourceInfo(DatabaseInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public void setTargetInfo(DatabaseInfo targetInfo) {
        this.targetInfo = targetInfo;
    }

    public void setDiff(DiffResult diff) {
        this.diff = diff;
    }

    public Migrate() {
    }
}

