/*
 * Decompiled with CFR 0.152.
 */
package cn.codeforfun.migrate.core.entity.structure;

import cn.codeforfun.migrate.core.diff.Difference;
import cn.codeforfun.migrate.core.entity.structure.Table;
import cn.codeforfun.migrate.core.entity.structure.annotations.DbUtilProperty;
import cn.codeforfun.migrate.core.utils.ObjectUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class Key
implements Difference,
Serializable {
    private static final long serialVersionUID = 5489127924529636485L;
    public static final String FLAG_PRIMARY = "PRIMARY";
    @DbUtilProperty(value="CONSTRAINT_SCHEMA")
    private String schema;
    @DbUtilProperty(value="CONSTRAINT_NAME")
    private String name;
    @DbUtilProperty(value="TABLE_NAME")
    private String tableName;
    @DbUtilProperty(value="COLUMN_NAME")
    private String columnName;
    @DbUtilProperty(value="ORDINAL_POSITION")
    private Long ordinalPosition;
    @DbUtilProperty(value="POSITION_IN_UNIQUE_CONSTRAINT")
    private Long positionInUniqueConstraint;
    @DbUtilProperty(value="REFERENCED_TABLE_SCHEMA")
    private String referencedSchema;
    @DbUtilProperty(value="REFERENCED_TABLE_NAME")
    private String referencedTable;
    @DbUtilProperty(value="REFERENCED_COLUMN_NAME")
    private String referencedColumn;
    private Table table;

    public static void resolveDeleteSql(List<Difference> delete, List<String> sqlList) {
        List otherKeyList;
        List deleteKeyList = delete.stream().filter(s -> s instanceof Key).map(s -> (Key)s).collect(Collectors.toList());
        List uniqueKeyList = deleteKeyList.stream().filter(s -> !FLAG_PRIMARY.equals(s.getName()) && ObjectUtils.isEmpty(s.getReferencedColumn())).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(uniqueKeyList)) {
            Map<String, List<Key>> collect = uniqueKeyList.stream().collect(Collectors.groupingBy(Key::getTableName));
            for (Map.Entry<String, List<Key>> entry : collect.entrySet()) {
                Map<String, List<Key>> collect1 = entry.getValue().stream().collect(Collectors.groupingBy(Key::getName));
                for (Map.Entry<String, List<Key>> stringListEntry : collect1.entrySet()) {
                    sqlList.add("ALTER TABLE `" + entry.getKey() + "` DROP KEY `" + stringListEntry.getKey() + "`;");
                }
            }
        }
        if (!ObjectUtils.isEmpty(otherKeyList = deleteKeyList.stream().filter(s -> FLAG_PRIMARY.equals(s.getName()) || !ObjectUtils.isEmpty(s.getReferencedColumn())).collect(Collectors.toList()))) {
            for (Key key : otherKeyList) {
                sqlList.add(key.getDeleteSql());
            }
        }
    }

    public static void resolveCreateSql(List<Difference> create, List<String> sqlList) {
        List otherKeyList;
        Map<String, List<Key>> tableList;
        if (ObjectUtils.isEmpty(create)) {
            return;
        }
        List keyList = create.stream().filter(s -> s instanceof Key).map(s -> (Key)s).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(keyList)) {
            return;
        }
        List uniqueKeyList = keyList.stream().filter(s -> !FLAG_PRIMARY.equals(s.getName()) && ObjectUtils.isEmpty(s.getReferencedColumn())).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(uniqueKeyList) && !ObjectUtils.isEmpty(tableList = uniqueKeyList.stream().collect(Collectors.groupingBy(Key::getTableName)))) {
            for (Map.Entry<String, List<Key>> e : tableList.entrySet()) {
                Map<String, List<Key>> listMap = e.getValue().stream().collect(Collectors.groupingBy(Key::getName));
                if (ObjectUtils.isEmpty(listMap)) continue;
                for (Map.Entry<String, List<Key>> j : listMap.entrySet()) {
                    List columnList = j.getValue().stream().map(Key::getColumnName).collect(Collectors.toList());
                    if (ObjectUtils.isEmpty(columnList)) continue;
                    StringBuilder sb = new StringBuilder();
                    sb.append("ALTER TABLE `");
                    sb.append(e.getKey());
                    sb.append("` ADD CONSTRAINT `");
                    sb.append(j.getKey());
                    sb.append("` UNIQUE (");
                    for (String s2 : columnList) {
                        sb.append("`").append(s2).append("`").append(", ");
                    }
                    sb.setLength(sb.length() - 2);
                    sb.append(");");
                    sqlList.add(sb.toString());
                }
            }
        }
        if (!ObjectUtils.isEmpty(otherKeyList = keyList.stream().filter(s -> FLAG_PRIMARY.equals(s.getName()) || !ObjectUtils.isEmpty(s.getReferencedColumn())).collect(Collectors.toList()))) {
            for (Key key : otherKeyList) {
                sqlList.add(key.getCreateSql());
            }
        }
    }

    public static void resolveUpdateSql(List<Difference> update, List<String> sqlList) {
        List otherKeyList;
        if (ObjectUtils.isEmpty(update)) {
            return;
        }
        List keyList = update.stream().filter(s -> s instanceof Key).map(s -> (Key)s).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(keyList)) {
            return;
        }
        List uniqueKeyList = keyList.stream().filter(s -> !FLAG_PRIMARY.equals(s.getName()) && ObjectUtils.isEmpty(s.getReferencedColumn())).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(uniqueKeyList)) {
            Map<String, List<Key>> tableList = uniqueKeyList.stream().collect(Collectors.groupingBy(Key::getTableName));
            if (!ObjectUtils.isEmpty(tableList)) {
                for (Map.Entry<String, List<Key>> e : tableList.entrySet()) {
                    Map<String, List<Key>> listMap = e.getValue().stream().collect(Collectors.groupingBy(Key::getName));
                    if (ObjectUtils.isEmpty(listMap)) continue;
                    for (Map.Entry<String, List<Key>> j : listMap.entrySet()) {
                        List columnList = j.getValue().stream().map(Key::getColumnName).collect(Collectors.toList());
                        if (ObjectUtils.isEmpty(columnList)) continue;
                        sqlList.add("ALTER TABLE `" + e.getKey() + "` DROP KEY `" + j.getKey() + "`;");
                    }
                }
            }
            Key.resolveCreateSql(update, sqlList);
        }
        if (!ObjectUtils.isEmpty(otherKeyList = keyList.stream().filter(s -> FLAG_PRIMARY.equals(s.getName()) || !ObjectUtils.isEmpty(s.getReferencedColumn())).collect(Collectors.toList()))) {
            for (Key key : otherKeyList) {
                sqlList.add(key.getDeleteSql());
                sqlList.add(key.getCreateSql());
            }
        }
    }

    @Override
    @JsonIgnore
    public String getDeleteSql() {
        StringBuilder sb = new StringBuilder();
        if (FLAG_PRIMARY.equals(this.name)) {
            sb.append("ALTER TABLE `").append(this.tableName).append("` DROP PRIMARY KEY;");
        } else if (ObjectUtils.isEmpty(this.referencedSchema) && ObjectUtils.isEmpty(this.referencedTable) && ObjectUtils.isEmpty(this.referencedColumn)) {
            sb.append("ALTER TABLE `").append(this.tableName).append("` DROP KEY `").append(this.name).append("`;");
        } else {
            sb.append("ALTER TABLE `").append(this.tableName).append("` DROP FOREIGN KEY `").append(this.name).append("`;");
        }
        return sb.toString();
    }

    @JsonIgnore
    public String getCreateTableSql() {
        StringBuilder sb = new StringBuilder();
        if (ObjectUtils.isEmpty(this.referencedSchema) && ObjectUtils.isEmpty(this.referencedTable) && ObjectUtils.isEmpty(this.referencedColumn)) {
            sb.append("CONSTRAINT `").append(this.name).append("` UNIQUE (`").append(this.columnName).append("`),");
        } else {
            sb.append("CONSTRAINT `").append(this.name).append("` ").append("FOREIGN KEY (`").append(this.columnName).append("`) ").append("REFERENCES `").append(this.referencedTable).append("` ").append("(`").append(this.referencedColumn).append("`),");
        }
        return sb.toString();
    }

    @Override
    @JsonIgnore
    public String getCreateSql() {
        StringBuilder sb = new StringBuilder();
        if (FLAG_PRIMARY.equals(this.name)) {
            sb.append("ALTER TABLE `").append(this.tableName).append("` ADD PRIMARY KEY (`").append(this.columnName).append("`);");
        } else if (ObjectUtils.isEmpty(this.referencedSchema) && ObjectUtils.isEmpty(this.referencedTable) && ObjectUtils.isEmpty(this.referencedColumn)) {
            sb.append("ALTER TABLE `").append(this.tableName).append("` ADD CONSTRAINT `").append(this.name).append("` UNIQUE (`").append(this.columnName).append("`);");
        } else {
            sb.append("ALTER TABLE `").append(this.tableName).append("` ADD KEY `").append(this.name).append("` (`").append(this.columnName).append("`); ");
            sb.append("ALTER TABLE `").append(this.tableName).append("` ADD CONSTRAINT `").append(this.name).append("` ").append("FOREIGN KEY (`").append(this.columnName).append("`) ").append("REFERENCES `").append(this.referencedTable).append("` ").append("(`").append(this.referencedColumn).append("`);");
        }
        return sb.toString();
    }

    @Override
    @JsonIgnore
    public String getUpdateSql() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Key)) {
            return false;
        }
        Key key = (Key)o;
        return Objects.equals(this.getName(), key.getName()) && Objects.equals(this.getTableName(), key.getTableName()) && Objects.equals(this.getColumnName(), key.getColumnName()) && Objects.equals(this.getOrdinalPosition(), key.getOrdinalPosition()) && Objects.equals(this.getPositionInUniqueConstraint(), key.getPositionInUniqueConstraint()) && Objects.equals(this.getReferencedSchema(), key.getReferencedSchema()) && Objects.equals(this.getReferencedTable(), key.getReferencedTable()) && Objects.equals(this.getReferencedColumn(), key.getReferencedColumn());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getTableName(), this.getColumnName(), this.getOrdinalPosition(), this.getPositionInUniqueConstraint(), this.getReferencedSchema(), this.getReferencedTable(), this.getReferencedColumn());
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Long getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public Long getPositionInUniqueConstraint() {
        return this.positionInUniqueConstraint;
    }

    public String getReferencedSchema() {
        return this.referencedSchema;
    }

    public String getReferencedTable() {
        return this.referencedTable;
    }

    public String getReferencedColumn() {
        return this.referencedColumn;
    }

    public Table getTable() {
        return this.table;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setOrdinalPosition(Long ordinalPosition) {
        this.ordinalPosition = ordinalPosition;
    }

    public void setPositionInUniqueConstraint(Long positionInUniqueConstraint) {
        this.positionInUniqueConstraint = positionInUniqueConstraint;
    }

    public void setReferencedSchema(String referencedSchema) {
        this.referencedSchema = referencedSchema;
    }

    public void setReferencedTable(String referencedTable) {
        this.referencedTable = referencedTable;
    }

    public void setReferencedColumn(String referencedColumn) {
        this.referencedColumn = referencedColumn;
    }

    public void setTable(Table table) {
        this.table = table;
    }
}

