/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.compiler.processor;

import com.dailystudio.devbricksx.compiler.processor.AbsSingleTypeElementProcessor;
import com.dailystudio.devbricksx.compiler.processor.AbsTypeElementsGroupProcessor;
import com.dailystudio.devbricksx.compiler.utils.LogUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public abstract class AbsBaseProcessor
extends AbstractProcessor {
    private ProcessingEnvironment mProcessingEnv;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.mProcessingEnv = processingEnv;
    }

    protected abstract Map<Class<? extends Annotation>, List<? extends AbsSingleTypeElementProcessor>> getTypeElementProcessors();

    protected abstract Map<Class<? extends Annotation>, List<? extends AbsTypeElementsGroupProcessor>> getTypeElementsGroupProcessors();

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnv) {
        Set<String> supportedAnnotations = this.getSupportedAnnotationTypes();
        if (supportedAnnotations == null) {
            return false;
        }
        HashMap<Class<? extends Annotation>, List<TypeElement>> typeElementsMap = new HashMap<Class<? extends Annotation>, List<TypeElement>>();
        for (String annotation : supportedAnnotations) {
            Class<?> annotationClass;
            try {
                annotationClass = Class.forName(annotation);
            }
            catch (ClassNotFoundException e) {
                this.error("failed to parse annotation class for: %s", annotation);
                continue;
            }
            Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(annotationClass);
            ArrayList<TypeElement> typeElements = null;
            for (Element element : elements) {
                if (!(element instanceof TypeElement)) continue;
                if (typeElements == null) {
                    typeElements = new ArrayList<TypeElement>();
                }
                typeElements.add((TypeElement)element);
            }
            if (typeElements == null) continue;
            typeElementsMap.put(annotationClass, typeElements);
        }
        Object preResults = this.preProcessTypeElements(typeElementsMap);
        this.applySingleTypeElementProcessor(typeElementsMap, roundEnv, preResults);
        this.applyTypeElementsGroupProcessors(typeElementsMap, roundEnv, preResults);
        return true;
    }

    protected Object preProcessTypeElements(Map<Class<? extends Annotation>, List<TypeElement>> typeElementsMap) {
        return null;
    }

    private void applySingleTypeElementProcessor(Map<Class<? extends Annotation>, List<TypeElement>> typeElementsMap, RoundEnvironment roundEnv, Object preResults) {
        Map<Class<? extends Annotation>, List<? extends AbsSingleTypeElementProcessor>> mapOfSingleTypeElementProcessors = this.getTypeElementProcessors();
        if (mapOfSingleTypeElementProcessors == null) {
            return;
        }
        Set<Class<? extends Annotation>> annotations = mapOfSingleTypeElementProcessors.keySet();
        if (annotations == null) {
            return;
        }
        for (Class<? extends Annotation> annotation : annotations) {
            List<TypeElement> typeElements;
            List<? extends AbsSingleTypeElementProcessor> singleTypeElementProcessors = mapOfSingleTypeElementProcessors.get(annotation);
            if (singleTypeElementProcessors == null || (typeElements = typeElementsMap.get(annotation)) == null) continue;
            for (TypeElement typeElement : typeElements) {
                for (AbsSingleTypeElementProcessor absSingleTypeElementProcessor : singleTypeElementProcessors) {
                    absSingleTypeElementProcessor.attachToProcessEnvironment(this.mProcessingEnv);
                    absSingleTypeElementProcessor.process(typeElement, roundEnv, preResults);
                    absSingleTypeElementProcessor.detachFromProcessEnvironment();
                }
            }
        }
    }

    private void applyTypeElementsGroupProcessors(Map<Class<? extends Annotation>, List<TypeElement>> typeElementsMap, RoundEnvironment roundEnv, Object preResults) {
        Map<Class<? extends Annotation>, List<? extends AbsTypeElementsGroupProcessor>> mapOfTypeElementsGroupProcessors = this.getTypeElementsGroupProcessors();
        if (mapOfTypeElementsGroupProcessors == null) {
            return;
        }
        Set<Class<? extends Annotation>> annotations = mapOfTypeElementsGroupProcessors.keySet();
        if (annotations == null) {
            return;
        }
        for (Class<? extends Annotation> annotation : annotations) {
            List<TypeElement> typeElements;
            List<? extends AbsTypeElementsGroupProcessor> typeElementsGroupProcessors = mapOfTypeElementsGroupProcessors.get(annotation);
            if (typeElementsGroupProcessors == null || (typeElements = typeElementsMap.get(annotation)) == null) continue;
            for (AbsTypeElementsGroupProcessor absTypeElementsGroupProcessor : typeElementsGroupProcessors) {
                absTypeElementsGroupProcessor.attachToProcessEnvironment(this.mProcessingEnv);
                absTypeElementsGroupProcessor.process(typeElements, roundEnv, preResults);
                absTypeElementsGroupProcessor.detachFromProcessEnvironment();
            }
        }
    }

    public void debug(String format, Object ... args) {
        LogUtils.debug(this.mProcessingEnv.getMessager(), format, args);
    }

    public void info(String format, Object ... args) {
        LogUtils.info(this.mProcessingEnv.getMessager(), format, args);
    }

    public void error(String format, Object ... args) {
        LogUtils.error(this.mProcessingEnv.getMessager(), format, args);
    }

    public void warn(String format, Object ... args) {
        LogUtils.warn(this.mProcessingEnv.getMessager(), format, args);
    }
}

