/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.compiler.processor;

import com.dailystudio.devbricksx.compiler.processor.AbsTypeElementProcessor;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;

public abstract class AbsSingleTypeElementProcessor
extends AbsTypeElementProcessor {
    public void process(TypeElement typeElement, RoundEnvironment roundEnv, Object preResults) {
        String typeName;
        String packageName = this.getPackageNameOfTypeElement(typeElement);
        List<AbsTypeElementProcessor.GeneratedResult> generatedResults = this.onProcess(typeElement, packageName, typeName = this.getTypeNameOfTypeElement(typeElement), roundEnv, preResults);
        if (generatedResults == null) {
            this.warn("no class generated for %s", typeElement);
            return;
        }
        for (AbsTypeElementProcessor.GeneratedResult result : generatedResults) {
            try {
                JavaFile.builder((String)result.packageName, (TypeSpec)result.builder.build()).build().writeTo(this.mFiler);
            }
            catch (IOException e) {
                this.error("generate class for [pkg: %s, builder: %s] failed: %s", result.packageName, result.builder, e.toString());
            }
        }
    }

    protected List<AbsTypeElementProcessor.GeneratedResult> singleResult(String packageName, TypeSpec.Builder classBuilder) {
        ArrayList<AbsTypeElementProcessor.GeneratedResult> results = new ArrayList<AbsTypeElementProcessor.GeneratedResult>();
        results.add(new AbsTypeElementProcessor.GeneratedResult(packageName, classBuilder));
        return results;
    }

    protected abstract List<AbsTypeElementProcessor.GeneratedResult> onProcess(TypeElement var1, String var2, String var3, RoundEnvironment var4, Object var5);
}

