/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.compiler.processor;

import com.dailystudio.devbricksx.compiler.utils.LogUtils;
import com.squareup.javapoet.TypeSpec;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public abstract class AbsTypeElementProcessor {
    protected Types mTypes;
    protected Filer mFiler;
    protected Elements mElementUtils;
    protected Types mTypesUtils;
    protected Messager mMessager;

    public void attachToProcessEnvironment(ProcessingEnvironment processingEnv) {
        if (processingEnv == null) {
            return;
        }
        this.mTypes = processingEnv.getTypeUtils();
        this.mFiler = processingEnv.getFiler();
        this.mElementUtils = processingEnv.getElementUtils();
        this.mTypesUtils = processingEnv.getTypeUtils();
        this.mMessager = processingEnv.getMessager();
    }

    public void detachFromProcessEnvironment() {
        this.mFiler = null;
        this.mElementUtils = null;
        this.mMessager = null;
    }

    protected void debug(String format, Object ... args) {
        LogUtils.debug(this.mMessager, format, args);
    }

    protected void info(String format, Object ... args) {
        LogUtils.info(this.mMessager, format, args);
    }

    protected void error(String format, Object ... args) {
        LogUtils.error(this.mMessager, format, args);
    }

    public void warn(String format, Object ... args) {
        LogUtils.warn(this.mMessager, format, args);
    }

    protected String getPackageNameOfTypeElement(TypeElement typeElement) {
        if (typeElement == null) {
            return null;
        }
        return this.mElementUtils.getPackageOf(typeElement).getQualifiedName().toString();
    }

    protected String getTypeNameOfTypeElement(TypeElement typeElement) {
        if (typeElement == null) {
            return null;
        }
        return typeElement.getSimpleName().toString();
    }

    public static class GeneratedResult {
        public String packageName;
        public TypeSpec.Builder builder;

        public GeneratedResult(String packageName, TypeSpec.Builder builder) {
            this.packageName = packageName;
            this.builder = builder;
        }
    }
}

