/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.compiler.processor.roomcompanion;

import com.dailystudio.devbricksx.annotations.RoomCompanion;
import com.dailystudio.devbricksx.compiler.utils.NameUtils;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public class FieldsHelper {
    public static void primaryKeyFieldsToMethodParameters(MethodSpec.Builder methodBuilder, Map<String, TypeName> primaryKeyFields) {
        if (methodBuilder == null || primaryKeyFields == null) {
            return;
        }
        Set<String> keySet = primaryKeyFields.keySet();
        for (String filedName : keySet) {
            TypeName fieldType = primaryKeyFields.get(filedName);
            methodBuilder.addParameter(fieldType, filedName, new Modifier[0]);
        }
    }

    public static String primaryKeyFieldsToWhereClause(Map<String, TypeName> primaryKeyFields) {
        if (primaryKeyFields == null) {
            return "";
        }
        String[] keys = primaryKeyFields.keySet().toArray(new String[0]);
        StringBuilder whereClauseBuilder = new StringBuilder("where ");
        for (int i = 0; i < keys.length; ++i) {
            String filedName = keys[i];
            whereClauseBuilder.append(NameUtils.underscoreCaseName(filedName));
            whereClauseBuilder.append(" = :");
            whereClauseBuilder.append(filedName);
            if (i >= keys.length - 1) continue;
            whereClauseBuilder.append(" and ");
        }
        return whereClauseBuilder.toString();
    }

    public static String primaryKeyFieldsToFuncCallParameters(Map<String, TypeName> primaryKeyFields) {
        if (primaryKeyFields == null) {
            return "";
        }
        String[] keys = primaryKeyFields.keySet().toArray(new String[0]);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < keys.length; ++i) {
            String filedName = keys[i];
            builder.append(filedName);
            if (i >= keys.length - 1) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public static void collectPrimaryKeyFields(Element element, Map<String, TypeName> fields, Types typeUtils) {
        if (typeUtils == null || !(element instanceof TypeElement)) {
            return;
        }
        TypeElement typeElement = (TypeElement)element;
        RoomCompanion companionAnnotation = typeElement.getAnnotation(RoomCompanion.class);
        if (companionAnnotation == null) {
            return;
        }
        String[] primaryKeys = companionAnnotation.primaryKeys();
        if (primaryKeys == null || primaryKeys.length <= 0) {
            return;
        }
        HashSet<String> primaryKeySet = new HashSet<String>();
        for (String string : primaryKeys) {
            primaryKeySet.add(string);
        }
        List<? extends Element> subElements = typeElement.getEnclosedElements();
        for (Element element2 : subElements) {
            if (!(element2 instanceof VariableElement)) continue;
            VariableElement varElement = (VariableElement)element2;
            String varName = varElement.getSimpleName().toString();
            TypeMirror fieldType = varElement.asType();
            if (!primaryKeySet.contains(varName)) continue;
            fields.put(varName, TypeName.get((TypeMirror)fieldType));
        }
        TypeMirror superClass = typeElement.getSuperclass();
        if (superClass != null) {
            FieldsHelper.collectPrimaryKeyFields(typeUtils.asElement(superClass), fields, typeUtils);
        }
    }
}

