/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.compiler.processor.roomcompanion;

import com.dailystudio.devbricksx.compiler.processor.roomcompanion.GeneratedNames;
import com.dailystudio.devbricksx.compiler.processor.roomcompanion.TypeNamesUtils;
import com.dailystudio.devbricksx.compiler.utils.TextUtils;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.util.Set;

public class MethodStatementsGenerator {
    public static void outputDefault(String packageName, String typeName, MethodSpec.Builder methodSpecBuilder, String shadowMethodName, String methodParameters, Boolean hasReturn) {
        StringBuilder builder = new StringBuilder();
        if (hasReturn.booleanValue()) {
            builder.append("return ");
        }
        if (!TextUtils.isEmpty(methodParameters)) {
            builder.append("this.$N($N)");
            methodSpecBuilder.addStatement(builder.toString(), new Object[]{shadowMethodName, methodParameters});
        } else {
            builder.append("this.$N()");
            methodSpecBuilder.addStatement(builder.toString(), new Object[]{shadowMethodName});
        }
    }

    public static void outputLiveCompanionToLiveObject(String packageName, String typeName, MethodSpec.Builder methodSpecBuild, String shadowMethodName) {
        MethodStatementsGenerator.outputLiveCompanionToLiveObject(packageName, typeName, methodSpecBuild, shadowMethodName, null);
    }

    public static void outputLiveCompanionToLiveObject(String packageName, String typeName, MethodSpec.Builder methodSpecBuilder, String shadowMethodName, String methodParameters) {
        ClassName companion = TypeNamesUtils.getCompanionTypeName(packageName, typeName);
        TypeName liveDataOfCompanion = TypeNamesUtils.getLiveDataOfCompanionTypeName(packageName, typeName);
        TypeName liveDataOfObject = TypeNamesUtils.getLiveDataOfObjectTypeName(packageName, typeName);
        if (!TextUtils.isEmpty(methodParameters)) {
            methodSpecBuilder.addStatement("$T liveCompanion = this.$N($N)", new Object[]{liveDataOfCompanion, shadowMethodName, methodParameters});
        } else {
            methodSpecBuilder.addStatement("$T liveCompanion = this.$N()", new Object[]{liveDataOfCompanion, shadowMethodName});
        }
        methodSpecBuilder.beginControlFlow("if (liveCompanion == null)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("$T liveObject = $T.map(liveCompanion, $T.mapCompanionToObject)", new Object[]{liveDataOfObject, TypeNamesUtils.getTransformationsTypeName(), companion}).addStatement("return liveObject", new Object[0]).returns(liveDataOfObject);
    }

    public static void outputLiveCompanionsToLiveObjects(String packageName, String typeName, MethodSpec.Builder methodSpecBuild, String shadowMethodName) {
        MethodStatementsGenerator.outputLiveCompanionsToLiveObjects(packageName, typeName, methodSpecBuild, shadowMethodName, null);
    }

    public static void outputLiveCompanionsToLiveObjects(String packageName, String typeName, MethodSpec.Builder methodSpecBuilder, String shadowMethodName, String methodParameters) {
        ClassName companion = TypeNamesUtils.getCompanionTypeName(packageName, typeName);
        TypeName liveDataOfListOfCompanions = TypeNamesUtils.getLiveDataOfListOfCompanionsTypeName(packageName, typeName);
        TypeName liveDataOfListOfObjects = TypeNamesUtils.getLiveDataOfListOfObjectsTypeName(packageName, typeName);
        if (!TextUtils.isEmpty(methodParameters)) {
            methodSpecBuilder.addStatement("$T liveCompanions = this.$N($N)", new Object[]{liveDataOfListOfCompanions, shadowMethodName, methodParameters});
        } else {
            methodSpecBuilder.addStatement("$T liveCompanions = this.$N()", new Object[]{liveDataOfListOfCompanions, shadowMethodName});
        }
        methodSpecBuilder.beginControlFlow("if (liveCompanions == null)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("$T liveObjects = $T.map(liveCompanions, $T.mapCompanionsToObjects)", new Object[]{liveDataOfListOfObjects, TypeNamesUtils.getTransformationsTypeName(), companion}).addStatement("return liveObjects", new Object[0]).returns(liveDataOfListOfObjects);
    }

    public static void outputCompanionsToObjects(String packageName, String typeName, MethodSpec.Builder methodSpecBuild, String shadowMethodName) {
        MethodStatementsGenerator.outputCompanionsToObjects(packageName, typeName, methodSpecBuild, shadowMethodName, null);
    }

    public static void outputCompanionsToObjects(String packageName, String typeName, MethodSpec.Builder methodSpecBuilder, String shadowMethodName, String methodParameters) {
        ClassName arrayList = TypeNamesUtils.getArrayListTypeName();
        TypeName listOfCompanions = TypeNamesUtils.getListOfCompanionsTypeName(packageName, typeName);
        TypeName listOfObjects = TypeNamesUtils.getListOfObjectsTypeName(packageName, typeName);
        if (!TextUtils.isEmpty(methodParameters)) {
            methodSpecBuilder.addStatement("$T companions = this.$N($N)", new Object[]{listOfCompanions, shadowMethodName, methodParameters});
        } else {
            methodSpecBuilder.addStatement("$T companions = this.$N()", new Object[]{listOfCompanions, shadowMethodName});
        }
        methodSpecBuilder.beginControlFlow("if (companions == null)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("$T objects = new $T<>()", new Object[]{listOfObjects, arrayList}).beginControlFlow("for (int i = 0; i < companions.size(); i++)", new Object[0]).addStatement("objects.add(companions.get(i).toObject())", new Object[0]).endControlFlow().addStatement("return objects", new Object[0]).returns(listOfObjects);
    }

    public static void outputCompanionToObject(String packageName, String typeName, MethodSpec.Builder methodSpecBuild, String shadowMethodName) {
        MethodStatementsGenerator.outputCompanionsToObjects(packageName, typeName, methodSpecBuild, shadowMethodName, null);
    }

    public static void outputCompanionToObject(String packageName, String typeName, MethodSpec.Builder methodSpecBuilder, String shadowMethodName, String methodParameters) {
        ClassName companion = TypeNamesUtils.getCompanionTypeName(packageName, typeName);
        if (!TextUtils.isEmpty(methodParameters)) {
            methodSpecBuilder.addStatement("$T companion = this.$N($N)", new Object[]{companion, shadowMethodName, methodParameters});
        } else {
            methodSpecBuilder.addStatement("$T companion = this.$N()", new Object[]{companion, shadowMethodName});
        }
        methodSpecBuilder.beginControlFlow("if (companion == null)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("return companion.toObject()", new Object[0]);
    }

    public static void inputObjectToCompanion(String packageName, String typeName, MethodSpec.Builder methodSpecBuilder, String parameterName, String shadowParameterName) {
        ClassName companion = TypeNamesUtils.getCompanionTypeName(packageName, typeName);
        methodSpecBuilder.addStatement("$T $N = null", new Object[]{companion, shadowParameterName}).beginControlFlow("if ($N != null)", new Object[]{parameterName}).addStatement("$N = $T.fromObject($N)", new Object[]{shadowParameterName, companion, parameterName}).endControlFlow();
    }

    public static void inputObjectListToCompanionList(String packageName, String typeName, MethodSpec.Builder methodSpecBuilder, String parameterName, String shadowParameterName) {
        ClassName companion = TypeNamesUtils.getCompanionTypeName(packageName, typeName);
        ClassName arrayList = TypeNamesUtils.getArrayListTypeName();
        TypeName listOfCompanions = TypeNamesUtils.getListOfCompanionsTypeName(packageName, typeName);
        methodSpecBuilder.addStatement("$T $N = new $T<>()", new Object[]{listOfCompanions, shadowParameterName, arrayList}).beginControlFlow("if ($N != null)", new Object[]{parameterName}).beginControlFlow("for (int i = 0; i < $N.size(); i++)", new Object[]{parameterName}).addStatement("$N.add($T.fromObject($N.get(i)))", new Object[]{shadowParameterName, companion, parameterName}).endControlFlow().endControlFlow();
    }

    public static void inputObjectArrayToCompanionArray(String packageName, String typeName, MethodSpec.Builder methodSpecBuilder, String parameterName, String shadowParameterName) {
        String listName = new StringBuilder(shadowParameterName).insert(0, "listOf").toString();
        ClassName companion = TypeNamesUtils.getCompanionTypeName(packageName, typeName);
        ClassName arrayList = TypeNamesUtils.getArrayListTypeName();
        TypeName listOfCompanions = TypeNamesUtils.getListOfCompanionsTypeName(packageName, typeName);
        TypeName arrayOfCompanions = TypeNamesUtils.getArrayOfCompanionsTypeName(packageName, typeName);
        methodSpecBuilder.addStatement("$T $N = new $T<>()", new Object[]{listOfCompanions, listName, arrayList}).beginControlFlow("if ($N != null)", new Object[]{parameterName}).beginControlFlow("for (int i = 0; i < $N.length; i++)", new Object[]{parameterName}).addStatement("$N.add($T.fromObject($N[i]))", new Object[]{listName, companion, parameterName}).endControlFlow().endControlFlow().addStatement("$T $N = $N.toArray(new $T[0])", new Object[]{arrayOfCompanions, shadowParameterName, listName, companion});
    }

    public static void mapInputObjectAndObjects(String packageName, String typeName, MethodSpec.Builder methodSpecBuilder, Set<String> objectTypeParameters, Set<String> objectsListTypeParameters, Set<String> objectsArrayTypeParameters, String shadowMethodName, String methodParameters, boolean hasReturn) {
        for (String objectParam : objectTypeParameters) {
            MethodStatementsGenerator.inputObjectToCompanion(packageName, typeName, methodSpecBuilder, objectParam, GeneratedNames.getShadowParameterName(objectParam));
        }
        for (String objectParam : objectsListTypeParameters) {
            MethodStatementsGenerator.inputObjectListToCompanionList(packageName, typeName, methodSpecBuilder, objectParam, GeneratedNames.getShadowParameterName(objectParam));
        }
        for (String objectParam : objectsArrayTypeParameters) {
            MethodStatementsGenerator.inputObjectArrayToCompanionArray(packageName, typeName, methodSpecBuilder, objectParam, GeneratedNames.getShadowParameterName(objectParam));
        }
        if (hasReturn) {
            if (!TextUtils.isEmpty(methodParameters)) {
                methodSpecBuilder.addStatement("return this.$N($N)", new Object[]{shadowMethodName, methodParameters});
            } else {
                methodSpecBuilder.addStatement("return this.$N()", new Object[]{shadowMethodName});
            }
        } else if (!TextUtils.isEmpty(methodParameters)) {
            methodSpecBuilder.addStatement("this.$N($N)", new Object[]{shadowMethodName, methodParameters});
        } else {
            methodSpecBuilder.addStatement("this.$N()", new Object[]{shadowMethodName});
        }
    }

    public static void outputDataSourceCompanionsToLiveObjects(String packageName, String typeName, int pageSize, MethodSpec.Builder methodSpecBuild, String shadowMethodName) {
        MethodStatementsGenerator.outputDataSourceCompanionsToLiveObjects(packageName, typeName, pageSize, methodSpecBuild, shadowMethodName, null);
    }

    public static void outputDataSourceCompanionsToLiveObjects(String packageName, String typeName, int pageSize, MethodSpec.Builder methodSpecBuilder, String shadowMethodName, String methodParameters) {
        if (pageSize <= 0) {
            return;
        }
        ClassName companion = TypeNamesUtils.getCompanionTypeName(packageName, typeName);
        TypeName companionsFactory = TypeNamesUtils.getDataSourceFactoryOfCompanionsTypeName(packageName, typeName);
        TypeName objectsFactory = TypeNamesUtils.getDataSourceFactoryOfObjectsTypeName(packageName, typeName);
        TypeName liveDataOfPagedObjectsList = TypeNamesUtils.getLiveDataOfPagedListOfObjectsTypeName(packageName, typeName);
        ClassName pagedListBuilder = TypeNamesUtils.getPagedListBuilderTypeName();
        if (!TextUtils.isEmpty(methodParameters)) {
            methodSpecBuilder.addStatement("$T companionsFactory = this.$N($N)", new Object[]{companionsFactory, shadowMethodName, methodParameters});
        } else {
            methodSpecBuilder.addStatement("$T companionsFactory = this.$N()", new Object[]{companionsFactory, shadowMethodName});
        }
        methodSpecBuilder.beginControlFlow("if (companionsFactory == null)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("$T objectsFactory = companionsFactory.map($T.mapCompanionToObject)", new Object[]{objectsFactory, companion}).addStatement("$T liveData = new $T<>(objectsFactory, $L).build()", new Object[]{liveDataOfPagedObjectsList, pagedListBuilder, pageSize}).addStatement("return liveData", new Object[0]).returns(liveDataOfPagedObjectsList);
    }

    public static void outputDataSourceCompanionsToPagingSourceObjects(String packageName, String typeName, int pageSize, MethodSpec.Builder methodSpecBuild, String shadowMethodName) {
        MethodStatementsGenerator.outputDataSourceCompanionsToPagingSourceObjects(packageName, typeName, pageSize, methodSpecBuild, shadowMethodName, null);
    }

    public static void outputDataSourceCompanionsToPagingSourceObjects(String packageName, String typeName, int pageSize, MethodSpec.Builder methodSpecBuilder, String shadowMethodName, String methodParameters) {
        ClassName companion = TypeNamesUtils.getCompanionTypeName(packageName, typeName);
        TypeName companionsFactory = TypeNamesUtils.getDataSourceFactoryOfCompanionsTypeName(packageName, typeName);
        TypeName objectsFactory = TypeNamesUtils.getDataSourceFactoryOfObjectsTypeName(packageName, typeName);
        TypeName liveDataOfPagedObjectsList = TypeNamesUtils.getLiveDataOfPagedListOfObjectsTypeName(packageName, typeName);
        TypeName pagingSourceOfObjects = TypeNamesUtils.getPagingSourceOfObjectsTypeName(packageName, typeName);
        if (!TextUtils.isEmpty(methodParameters)) {
            methodSpecBuilder.addStatement("$T companionsFactory = this.$N($N)", new Object[]{companionsFactory, shadowMethodName, methodParameters});
        } else {
            methodSpecBuilder.addStatement("$T companionsFactory = this.$N()", new Object[]{companionsFactory, shadowMethodName});
        }
        methodSpecBuilder.beginControlFlow("if (companionsFactory == null)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("$T objectsFactory = companionsFactory.map($T.mapCompanionToObject)", new Object[]{objectsFactory, companion}).addStatement("return objectsFactory.asPagingSourceFactory().invoke()", new Object[0]).returns(pagingSourceOfObjects);
    }

    public static void outputFlowCompanionsToFlowObjects(String packageName, String typeName, MethodSpec.Builder methodSpecBuild, String shadowMethodName) {
        MethodStatementsGenerator.outputFlowCompanionsToFlowObjects(packageName, typeName, methodSpecBuild, shadowMethodName, null);
    }

    public static void outputFlowCompanionsToFlowObjects(String packageName, String typeName, MethodSpec.Builder methodSpecBuilder, String shadowMethodName, String methodParameters) {
        ClassName companion = TypeNamesUtils.getCompanionTypeName(packageName, typeName);
        TypeName flowOfCompanions = TypeNamesUtils.getFlowOfListOfCompanionsTypeName(packageName, typeName);
        TypeName flowOfObjects = TypeNamesUtils.getFlowOfListOfObjectsTypeName(packageName, typeName);
        ClassName kotlinCompatibleUtils = TypeNamesUtils.getKotlinCompatibleUtilsTypeName();
        if (!TextUtils.isEmpty(methodParameters)) {
            methodSpecBuilder.addStatement("$T companionsFlow = this.$N($N)", new Object[]{flowOfCompanions, shadowMethodName, methodParameters});
        } else {
            methodSpecBuilder.addStatement("$T companionsFlow = this.$N()", new Object[]{flowOfCompanions, shadowMethodName});
        }
        methodSpecBuilder.beginControlFlow("if (companionsFlow == null)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("$T objectsFlow = $T.INSTANCE.mapFlow(companionsFlow, $T.mapCompanionsToObjectsSuspend)", new Object[]{flowOfObjects, kotlinCompatibleUtils, companion}).addStatement("return objectsFlow", new Object[0]).returns(flowOfObjects);
    }
}

