/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.compiler.processor.roomcompanion;

import com.dailystudio.devbricksx.compiler.processor.roomcompanion.GeneratedNames;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Type;
import java.util.List;

public class TypeNamesUtils {
    public static boolean isTypeNameVoid(TypeName typeName) {
        return TypeNamesUtils.getVoidTypeName().equals((Object)typeName);
    }

    public static boolean isTypeNameOfList(TypeName typeName) {
        return typeName.toString().contains("java.util.List<");
    }

    public static TypeName getVoidTypeName() {
        return ClassName.VOID;
    }

    public static TypeName getContextTypeName() {
        return ClassName.get((String)"android.content", (String)"Context", (String[])new String[0]);
    }

    public static TypeName getRoomTypeName() {
        return ClassName.get((String)"androidx.room", (String)"Room", (String[])new String[0]);
    }

    public static TypeName getRoomDatabaseBuilderTypeName(TypeName className) {
        ClassName builder = ClassName.get((String)"androidx.room.RoomDatabase", (String)"Builder", (String[])new String[0]);
        return ParameterizedTypeName.get((ClassName)builder, (TypeName[])new TypeName[]{className});
    }

    public static TypeName getMigrationTypeName() {
        return ClassName.get((String)"androidx.room.migration", (String)"Migration", (String[])new String[0]);
    }

    public static ClassName getTransformationsTypeName() {
        return ClassName.get((String)"androidx.lifecycle", (String)"Transformations", (String[])new String[0]);
    }

    public static ClassName getLoggerTypeName() {
        return ClassName.get((String)"com.dailystudio.devbricksx.development", (String)"Logger", (String[])new String[0]);
    }

    public static TypeName getMapFunctionOfTypeName(TypeName typeClassNameA, TypeName typeClassNameB) {
        ClassName function = ClassName.get((String)"androidx.arch.core.util", (String)"Function", (String[])new String[0]);
        return ParameterizedTypeName.get((ClassName)function, (TypeName[])new TypeName[]{typeClassNameA, typeClassNameB});
    }

    public static TypeName getFunction2OfTypeName(TypeName typeClassNameA, TypeName typeClassNameB, TypeName typeClassNameC) {
        ClassName function = ClassName.get((String)"kotlin.jvm.functions", (String)"Function2", (String[])new String[0]);
        return ParameterizedTypeName.get((ClassName)function, (TypeName[])new TypeName[]{typeClassNameA, typeClassNameB, typeClassNameC});
    }

    public static TypeName getContinuationOfTypeName(TypeName typeClassName) {
        ClassName continuation = ClassName.get((String)"kotlin.coroutines", (String)"Continuation", (String[])new String[0]);
        return ParameterizedTypeName.get((ClassName)continuation, (TypeName[])new TypeName[]{typeClassName});
    }

    public static ClassName getTransformationFunctionTypeName() {
        return ClassName.get((String)"androidx.lifecycle", (String)"Transformations", (String[])new String[0]);
    }

    public static ClassName getArrayListTypeName() {
        return ClassName.get((String)"java.util", (String)"ArrayList", (String[])new String[0]);
    }

    public static ClassName getItemCallbackTypeName() {
        return ClassName.get((String)"androidx.recyclerview.widget.DiffUtil", (String)"ItemCallback", (String[])new String[0]);
    }

    public static TypeName getItemCallbackOfTypeName(TypeName typeClassName) {
        ClassName itemCallback = TypeNamesUtils.getItemCallbackTypeName();
        return ParameterizedTypeName.get((ClassName)itemCallback, (TypeName[])new TypeName[]{typeClassName});
    }

    public static TypeName getListOfTypeName(Class<?> primitiveClass) {
        return ParameterizedTypeName.get(List.class, (Type[])new Type[]{primitiveClass});
    }

    public static TypeName getListOfTypeName(TypeName typeClassName) {
        ClassName list = ClassName.get((String)"java.util", (String)"List", (String[])new String[0]);
        return ParameterizedTypeName.get((ClassName)list, (TypeName[])new TypeName[]{typeClassName});
    }

    public static TypeName getLiveDataOfTypeName(TypeName typeClassName) {
        ClassName list = ClassName.get((String)"androidx.lifecycle", (String)"LiveData", (String[])new String[0]);
        return ParameterizedTypeName.get((ClassName)list, (TypeName[])new TypeName[]{typeClassName});
    }

    public static TypeName getFlowOfTypeName(TypeName typeClassName) {
        ClassName list = ClassName.get((String)"kotlinx.coroutines.flow", (String)"Flow", (String[])new String[0]);
        return ParameterizedTypeName.get((ClassName)list, (TypeName[])new TypeName[]{typeClassName});
    }

    public static TypeName getDataSourceFactoryOfTypeName(TypeName typeClassName) {
        ClassName factory = ClassName.get((String)"androidx.paging.DataSource", (String)"Factory", (String[])new String[0]);
        return ParameterizedTypeName.get((ClassName)factory, (TypeName[])new TypeName[]{ClassName.get(Integer.class), typeClassName});
    }

    public static TypeName getPagingSourceOfTypeName(TypeName typeClassName) {
        ClassName factory = ClassName.get((String)"androidx.paging", (String)"PagingSource", (String[])new String[0]);
        return ParameterizedTypeName.get((ClassName)factory, (TypeName[])new TypeName[]{ClassName.get(Integer.class), typeClassName});
    }

    public static TypeName getPageListOfTypeName(TypeName typeClassName) {
        ClassName pagedList = ClassName.get((String)"androidx.paging", (String)"PagedList", (String[])new String[0]);
        return ParameterizedTypeName.get((ClassName)pagedList, (TypeName[])new TypeName[]{typeClassName});
    }

    public static ClassName getPagedListBuilderTypeName() {
        ClassName builder = ClassName.get((String)"androidx.paging", (String)"LivePagedListBuilder", (String[])new String[0]);
        return builder;
    }

    public static ClassName getKotlinCompatibleUtilsTypeName() {
        return ClassName.get((String)"com.dailystudio.devbricksx.utils", (String)"KotlinCompatibleUtils", (String[])new String[0]);
    }

    public static ClassName getObjectTypeName(String packageName, String typeElementName) {
        return ClassName.get((String)packageName, (String)typeElementName, (String[])new String[0]);
    }

    public static TypeName getArrayOfTypeName(TypeName typeName) {
        return ArrayTypeName.of((TypeName)typeName);
    }

    public static TypeName getArrayOfObjectsTypeName(String packageName, String typeElementName) {
        return TypeNamesUtils.getArrayOfTypeName((TypeName)TypeNamesUtils.getObjectTypeName(packageName, typeElementName));
    }

    public static TypeName getArrayOfCompanionsTypeName(String packageName, String typeElementName) {
        return TypeNamesUtils.getArrayOfTypeName((TypeName)TypeNamesUtils.getCompanionTypeName(packageName, typeElementName));
    }

    public static TypeName getListOfObjectsTypeName(String packageName, String typeElementName) {
        return TypeNamesUtils.getListOfTypeName((TypeName)TypeNamesUtils.getObjectTypeName(packageName, typeElementName));
    }

    public static TypeName getListOfCompanionsTypeName(String packageName, String typeElementName) {
        return TypeNamesUtils.getListOfTypeName((TypeName)TypeNamesUtils.getCompanionTypeName(packageName, typeElementName));
    }

    public static TypeName getLiveDataOfObjectTypeName(String packageName, String typeElementName) {
        return TypeNamesUtils.getLiveDataOfTypeName((TypeName)TypeNamesUtils.getObjectTypeName(packageName, typeElementName));
    }

    public static TypeName getLiveDataOfCompanionTypeName(String packageName, String typeElementName) {
        return TypeNamesUtils.getLiveDataOfTypeName((TypeName)TypeNamesUtils.getCompanionTypeName(packageName, typeElementName));
    }

    public static TypeName getLiveDataOfListOfObjectsTypeName(String packageName, String typeElementName) {
        return TypeNamesUtils.getLiveDataOfTypeName(TypeNamesUtils.getListOfObjectsTypeName(packageName, typeElementName));
    }

    public static TypeName getLiveDataOfListOfCompanionsTypeName(String packageName, String typeElementName) {
        return TypeNamesUtils.getLiveDataOfTypeName(TypeNamesUtils.getListOfCompanionsTypeName(packageName, typeElementName));
    }

    public static ClassName getCompanionTypeName(String packageName, String typeElementName) {
        return ClassName.get((String)packageName, (String)GeneratedNames.getRoomCompanionName(typeElementName), (String[])new String[0]);
    }

    public static TypeName getDataSourceFactoryOfCompanionsTypeName(String packageName, String typeElementName) {
        return TypeNamesUtils.getDataSourceFactoryOfTypeName((TypeName)TypeNamesUtils.getCompanionTypeName(packageName, typeElementName));
    }

    public static TypeName getPagingSourceOfCompanionsTypeName(String packageName, String typeElementName) {
        return TypeNamesUtils.getPagingSourceOfTypeName((TypeName)TypeNamesUtils.getCompanionTypeName(packageName, typeElementName));
    }

    public static TypeName getDataSourceFactoryOfObjectsTypeName(String packageName, String typeElementName) {
        return TypeNamesUtils.getDataSourceFactoryOfTypeName((TypeName)TypeNamesUtils.getObjectTypeName(packageName, typeElementName));
    }

    public static TypeName getPagingSourceOfObjectsTypeName(String packageName, String typeElementName) {
        return TypeNamesUtils.getPagingSourceOfTypeName((TypeName)TypeNamesUtils.getObjectTypeName(packageName, typeElementName));
    }

    public static TypeName getPagedListOfObjectsTypeName(String packageName, String typeElementName) {
        return TypeNamesUtils.getPageListOfTypeName((TypeName)TypeNamesUtils.getObjectTypeName(packageName, typeElementName));
    }

    public static TypeName getPagedListOfCompanionsTypeName(String packageName, String typeElementName) {
        return TypeNamesUtils.getPageListOfTypeName((TypeName)TypeNamesUtils.getCompanionTypeName(packageName, typeElementName));
    }

    public static TypeName getLiveDataOfPagedListOfObjectsTypeName(String packageName, String typeElementName) {
        return TypeNamesUtils.getLiveDataOfTypeName(TypeNamesUtils.getPagedListOfObjectsTypeName(packageName, typeElementName));
    }

    public static TypeName getLiveDataOfPagedListOfCompanionsTypeName(String packageName, String typeElementName) {
        return TypeNamesUtils.getLiveDataOfTypeName(TypeNamesUtils.getPagedListOfCompanionsTypeName(packageName, typeElementName));
    }

    public static TypeName getDummyMigrationTypeName() {
        return ClassName.get((String)"com.dailystudio.devbricksx.database", (String)"DummyMigration", (String[])new String[0]);
    }

    public static TypeName getFlowOfCompanionsTypeName(String packageName, String typeName) {
        return TypeNamesUtils.getFlowOfTypeName((TypeName)TypeNamesUtils.getCompanionTypeName(packageName, typeName));
    }

    public static TypeName getFlowOfObjectsTypeName(String packageName, String typeName) {
        return TypeNamesUtils.getFlowOfTypeName((TypeName)TypeNamesUtils.getObjectTypeName(packageName, typeName));
    }

    public static TypeName getFlowOfListOfCompanionsTypeName(String packageName, String typeName) {
        return TypeNamesUtils.getFlowOfTypeName(TypeNamesUtils.getListOfCompanionsTypeName(packageName, typeName));
    }

    public static TypeName getFlowOfListOfObjectsTypeName(String packageName, String typeName) {
        return TypeNamesUtils.getFlowOfTypeName(TypeNamesUtils.getListOfObjectsTypeName(packageName, typeName));
    }
}

