/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.compiler.processor.roomcompanion.typeelementprocessor;

import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Update;
import com.dailystudio.devbricksx.annotations.DaoExtension;
import com.dailystudio.devbricksx.annotations.Page;
import com.dailystudio.devbricksx.compiler.processor.AbsSingleTypeElementProcessor;
import com.dailystudio.devbricksx.compiler.processor.AbsTypeElementProcessor;
import com.dailystudio.devbricksx.compiler.processor.roomcompanion.GeneratedNames;
import com.dailystudio.devbricksx.compiler.processor.roomcompanion.MethodStatementsGenerator;
import com.dailystudio.devbricksx.compiler.processor.roomcompanion.TypeNamesUtils;
import com.dailystudio.devbricksx.compiler.utils.AnnotationsUtils;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class DaoExtensionClassProcessor
extends AbsSingleTypeElementProcessor {
    @Override
    protected List<AbsTypeElementProcessor.GeneratedResult> onProcess(TypeElement typeElement, String packageName, String typeName, RoundEnvironment roundEnv, Object preResults) {
        ClassName extension = ClassName.get((String)packageName, (String)typeName, (String[])new String[0]);
        ClassName generatedClassName = ClassName.get((String)packageName, (String)GeneratedNames.getDaoExtensionCompanionName(typeName), (String[])new String[0]);
        this.debug("generated class = [%s]", generatedClassName);
        DaoExtension daoExtension = typeElement.getAnnotation(DaoExtension.class);
        if (daoExtension == null) {
            return null;
        }
        ClassName object = AnnotationsUtils.getClassValueFromAnnotation(typeElement, "entity");
        this.debug("object = %s", object);
        if (object == null) {
            return null;
        }
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((ClassName)generatedClassName).addModifiers(new Modifier[]{Modifier.ABSTRACT}).addModifiers(new Modifier[]{Modifier.PUBLIC});
        switch (typeElement.getKind()) {
            case CLASS: {
                classBuilder.superclass((TypeName)extension);
                break;
            }
            case INTERFACE: {
                classBuilder.addSuperinterface((TypeName)extension);
                break;
            }
            default: {
                this.error("only classes or interfaces can be annotated.", new Object[0]);
                return null;
            }
        }
        List<? extends Element> subElements = typeElement.getEnclosedElements();
        for (Element element : subElements) {
            if (!(element instanceof ExecutableElement)) continue;
            this.debug("processing method: %s", element);
            ExecutableElement executableElement = (ExecutableElement)element;
            if (executableElement.getAnnotation(Query.class) != null) {
                this.handleQueryMethod(object.packageName(), object.simpleName(), executableElement, classBuilder);
                continue;
            }
            if (executableElement.getAnnotation(Insert.class) != null) {
                this.handleWriteActionMethod(object.packageName(), object.simpleName(), Insert.class, executableElement, classBuilder, false);
                continue;
            }
            if (executableElement.getAnnotation(Update.class) != null) {
                this.handleWriteActionMethod(object.packageName(), object.simpleName(), Update.class, executableElement, classBuilder, true);
                continue;
            }
            if (executableElement.getAnnotation(Delete.class) == null) continue;
            this.handleWriteActionMethod(object.packageName(), object.simpleName(), Delete.class, executableElement, classBuilder, true);
        }
        return this.singleResult(packageName, classBuilder);
    }

    private void handleQueryMethod(String objectPackage, String objectTypeName, ExecutableElement executableElement, TypeSpec.Builder classBuilder) {
        Query query = executableElement.getAnnotation(Query.class);
        ClassName object = TypeNamesUtils.getObjectTypeName(objectPackage, objectTypeName);
        TypeName listOfObjects = TypeNamesUtils.getListOfObjectsTypeName(objectPackage, objectTypeName);
        TypeName liveDataOfListOfObjects = TypeNamesUtils.getLiveDataOfListOfObjectsTypeName(objectPackage, objectTypeName);
        TypeName liveDataOfObject = TypeNamesUtils.getLiveDataOfObjectTypeName(objectPackage, objectTypeName);
        ClassName companion = TypeNamesUtils.getCompanionTypeName(objectPackage, objectTypeName);
        TypeName listOfCompanions = TypeNamesUtils.getListOfCompanionsTypeName(objectPackage, objectTypeName);
        TypeName liveDataOfListOfCompanions = TypeNamesUtils.getLiveDataOfListOfCompanionsTypeName(objectPackage, objectTypeName);
        TypeName liveDataOfCompanion = TypeNamesUtils.getLiveDataOfCompanionTypeName(objectPackage, objectTypeName);
        TypeName liveDataOfPagedObjectsList = TypeNamesUtils.getLiveDataOfPagedListOfObjectsTypeName(objectPackage, objectTypeName);
        TypeName pagingSourceOfObjects = TypeNamesUtils.getPagingSourceOfObjectsTypeName(objectPackage, objectTypeName);
        TypeName dataSourceFactoryOfCompanions = TypeNamesUtils.getDataSourceFactoryOfCompanionsTypeName(objectPackage, objectTypeName);
        TypeName flowOfCompanions = TypeNamesUtils.getFlowOfListOfCompanionsTypeName(objectPackage, objectTypeName);
        TypeName flowOfObjects = TypeNamesUtils.getFlowOfListOfObjectsTypeName(objectPackage, objectTypeName);
        TypeName returnTypeName = TypeName.get((TypeMirror)executableElement.getReturnType());
        this.debug("returnTypeName = %s", returnTypeName);
        int pageSize = 10;
        Page pageAnnotation = executableElement.getAnnotation(Page.class);
        if (pageAnnotation != null) {
            pageSize = pageAnnotation.pageSize();
        }
        String shadowMethodName = GeneratedNames.getShadowMethodName(executableElement.getSimpleName().toString());
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)shadowMethodName).addAnnotation(AnnotationSpec.get((Annotation)query)).addModifiers(new Modifier[]{Modifier.ABSTRACT});
        if (returnTypeName.equals((Object)object)) {
            methodSpecBuilder.returns((TypeName)companion);
        } else if (returnTypeName.equals((Object)listOfObjects)) {
            methodSpecBuilder.returns(listOfCompanions);
        } else if (returnTypeName.equals((Object)liveDataOfListOfObjects)) {
            methodSpecBuilder.returns(liveDataOfListOfCompanions);
        } else if (returnTypeName.equals((Object)liveDataOfObject)) {
            methodSpecBuilder.returns(liveDataOfCompanion);
        } else if (returnTypeName.equals((Object)liveDataOfPagedObjectsList)) {
            methodSpecBuilder.returns(dataSourceFactoryOfCompanions);
        } else if (returnTypeName.equals((Object)pagingSourceOfObjects)) {
            methodSpecBuilder.returns(dataSourceFactoryOfCompanions);
        } else if (returnTypeName.equals((Object)flowOfObjects)) {
            methodSpecBuilder.returns(flowOfCompanions);
        } else {
            methodSpecBuilder.returns(returnTypeName);
        }
        StringBuilder parametersBuilder = new StringBuilder();
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters != null && parameters.size() > 0) {
            int N = parameters.size();
            for (int i = 0; i < N; ++i) {
                VariableElement param = parameters.get(i);
                String paramName = param.getSimpleName().toString();
                methodSpecBuilder.addParameter(TypeName.get((TypeMirror)param.asType()), paramName, new Modifier[0]);
                parametersBuilder.append(paramName);
                if (i >= N - 1) continue;
                parametersBuilder.append(", ");
            }
        }
        classBuilder.addMethod(methodSpecBuilder.build());
        MethodSpec.Builder methodShadowSpecBuilder = MethodSpec.overriding((ExecutableElement)executableElement);
        if (returnTypeName.equals((Object)object)) {
            MethodStatementsGenerator.outputCompanionToObject(objectPackage, objectTypeName, methodShadowSpecBuilder, shadowMethodName, parametersBuilder.toString());
        } else if (returnTypeName.equals((Object)listOfObjects)) {
            MethodStatementsGenerator.outputCompanionsToObjects(objectPackage, objectTypeName, methodShadowSpecBuilder, shadowMethodName, parametersBuilder.toString());
        } else if (returnTypeName.equals((Object)liveDataOfListOfObjects)) {
            MethodStatementsGenerator.outputLiveCompanionsToLiveObjects(objectPackage, objectTypeName, methodShadowSpecBuilder, shadowMethodName, parametersBuilder.toString());
        } else if (returnTypeName.equals((Object)liveDataOfObject)) {
            MethodStatementsGenerator.outputLiveCompanionToLiveObject(objectPackage, objectTypeName, methodShadowSpecBuilder, shadowMethodName, parametersBuilder.toString());
        } else if (returnTypeName.equals((Object)liveDataOfPagedObjectsList)) {
            MethodStatementsGenerator.outputDataSourceCompanionsToLiveObjects(objectPackage, objectTypeName, pageSize, methodShadowSpecBuilder, shadowMethodName, parametersBuilder.toString());
        } else if (returnTypeName.equals((Object)pagingSourceOfObjects)) {
            MethodStatementsGenerator.outputDataSourceCompanionsToPagingSourceObjects(objectPackage, objectTypeName, pageSize, methodShadowSpecBuilder, shadowMethodName, parametersBuilder.toString());
        } else if (returnTypeName.equals((Object)flowOfObjects)) {
            MethodStatementsGenerator.outputFlowCompanionsToFlowObjects(objectPackage, objectTypeName, methodShadowSpecBuilder, shadowMethodName, parametersBuilder.toString());
        } else {
            MethodStatementsGenerator.outputDefault(objectPackage, objectTypeName, methodShadowSpecBuilder, shadowMethodName, parametersBuilder.toString(), !TypeNamesUtils.isTypeNameVoid(returnTypeName));
        }
        classBuilder.addMethod(methodShadowSpecBuilder.build());
    }

    private void handleWriteActionMethod(String objectPackage, String objectTypeName, Class annotationClass, ExecutableElement executableElement, TypeSpec.Builder classBuilder, Boolean alwaysReturnVoid) {
        ClassName object = TypeNamesUtils.getObjectTypeName(objectPackage, objectTypeName);
        ClassName companion = TypeNamesUtils.getCompanionTypeName(objectPackage, objectTypeName);
        TypeName listOfObjects = TypeNamesUtils.getListOfObjectsTypeName(objectPackage, objectTypeName);
        TypeName listOfCompanions = TypeNamesUtils.getListOfCompanionsTypeName(objectPackage, objectTypeName);
        TypeName arrayOfObjects = TypeNamesUtils.getArrayOfObjectsTypeName(objectPackage, objectTypeName);
        TypeName arrayOfCompanions = TypeNamesUtils.getArrayOfCompanionsTypeName(objectPackage, objectTypeName);
        TypeName returnTypeName = TypeName.get((TypeMirror)executableElement.getReturnType());
        boolean hasReturn = !TypeNamesUtils.isTypeNameVoid(returnTypeName) && alwaysReturnVoid == false;
        boolean collectionOperation = TypeNamesUtils.isTypeNameOfList(returnTypeName);
        String shadowMethodName = GeneratedNames.getShadowMethodName(executableElement.getSimpleName().toString());
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)shadowMethodName).addAnnotation(AnnotationSpec.builder((Class)annotationClass).addMember("entity", "$N.class", new Object[]{GeneratedNames.getRoomCompanionName(objectTypeName)}).build()).addModifiers(new Modifier[]{Modifier.ABSTRACT});
        if (hasReturn) {
            if (collectionOperation) {
                methodSpecBuilder.returns(TypeNamesUtils.getListOfTypeName(Long.class));
            } else {
                methodSpecBuilder.returns(Long.class);
            }
        }
        StringBuilder parametersBuilder = new StringBuilder();
        HashSet<String> objectTypeParameters = new HashSet<String>();
        HashSet<String> objectsListTypeParameters = new HashSet<String>();
        HashSet<String> objectsArrayTypeParameters = new HashSet<String>();
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters != null && parameters.size() > 0) {
            int N = parameters.size();
            for (int i = 0; i < N; ++i) {
                String paramName;
                VariableElement param = parameters.get(i);
                TypeName paramTypeName = TypeName.get((TypeMirror)param.asType());
                if (object.equals((Object)paramTypeName)) {
                    paramName = GeneratedNames.getShadowParameterName(param);
                    methodSpecBuilder.addParameter((TypeName)companion, paramName, new Modifier[0]);
                    objectTypeParameters.add(param.getSimpleName().toString());
                } else if (listOfObjects.equals((Object)paramTypeName)) {
                    paramName = GeneratedNames.getShadowParameterName(param);
                    methodSpecBuilder.addParameter(listOfCompanions, paramName, new Modifier[0]);
                    objectsListTypeParameters.add(param.getSimpleName().toString());
                } else if (arrayOfObjects.equals((Object)paramTypeName)) {
                    paramName = GeneratedNames.getShadowParameterName(param);
                    methodSpecBuilder.addParameter(arrayOfCompanions, paramName, new Modifier[0]);
                    objectsArrayTypeParameters.add(param.getSimpleName().toString());
                } else {
                    paramName = param.getSimpleName().toString();
                    methodSpecBuilder.addParameter(TypeName.get((TypeMirror)param.asType()), paramName, new Modifier[0]);
                }
                parametersBuilder.append(paramName);
                if (i >= N - 1) continue;
                parametersBuilder.append(", ");
            }
        }
        classBuilder.addMethod(methodSpecBuilder.build());
        MethodSpec.Builder methodShadowSpecBuilder = MethodSpec.overriding((ExecutableElement)executableElement);
        MethodStatementsGenerator.mapInputObjectAndObjects(objectPackage, objectTypeName, methodShadowSpecBuilder, objectTypeParameters, objectsListTypeParameters, objectsArrayTypeParameters, shadowMethodName, parametersBuilder.toString(), hasReturn);
        classBuilder.addMethod(methodShadowSpecBuilder.build());
    }
}

